/*
 *      #####################################################################
 *
 *        
 *        This software is provided 'as is', without warranty of any kind,
 *        express or implied. In no event shall the author be held liable
 *        for any damages arising from the use of this software.
 *
 *        Permission to use, copy, modify, and distribute this software and
 *        its documentation for non-commercial purposes is hereby granted,
 *        provided that the above copyright notice and this disclaimer appear
 *        in all copies and supporting documentation.
 *
 *        The software must NOT be sold or used as part of a any commercial
 *        or "non-free" product.
 *
 *      #####################################################################
 */

/*------------------------------------------------------------------------------
 *
 *  
 *
 */

#include <windows.h>
#include <windowsx.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <time.h>     //for rand() function
#include <process.h>  //for the separate thread for the Alert message

#include <stdarg.h>
#include <tchar.h>
#include <ctype.h>
#include <complex.h>
#include <commctrl.h>
#include <commdlg.h>
#include <richedit.h>
#include <vfw.h>
#include <GdiPlus.h>

#include "pa_host.h"
#include "portaudio.h"
#include "dspmath.h"
#include "coeffs.h"


#include "main.h"

#include "wsq_varicode tables.c"
/* KA4CDN forward decls */
void directCmdReadFile( unsigned char *msgBuf, unsigned char *rcvdCall );
void directCmdDeleteFile( unsigned char *msgBuf, unsigned char *rcvdCall );


extern int FS = 12000;//8000;
#define FPB           90//45        //Must be multiples of 5 to avoid 15 sample dot patterning on SSTV display - why, though?
#define FFT_SIZE_IN   4096               // time domain input points for the FFT

#define NFFTPLOTPOINTS (FFT_SIZE_IN/4 + 1)  // number of bins in FFT output

#define SMOOTH_K    0.13333333

#define ASCII_XON       0x11 //for serial comms routine
#define ASCII_XOFF      0x13

//**********Polynomials for CRC8*********************

#define GP  0x107   /* x^8 + x^2 + x + 1 */ // used in IEEE 801.16 CCIT radio stuff (we don't use it hewre though)
#define DI  0x07                            //use this one instead


static unsigned char crc8_table[256];     /* 8-bit table */
static int made_table=0;
//***************************************************
int QTC_ID;

  float   g_fltFftBufRe[FFT_SIZE_IN*2];       //buffers for FFT on raw input samples
  float   g_fltFftBufIm[FFT_SIZE_IN*2];
  float   g_fltPlotFftV[NFFTPLOTPOINTS*8];

  float   Speed_Re[FFT_SIZE_IN*2];    //FFT buffers for un-windowed FFT's for use in speed meter
  float   Speed_Im[FFT_SIZE_IN*2];
  float   SpeedPlotFft[NFFTPLOTPOINTS*8];


  float   g_PlotPeak[65536];//NFFTPLOTPOINTS*8];

  float   peak_symbol;
  int     peak_index;
  float   sync[18];

  int     sample_buffer[400000];	//save individual FFT slices (allow for 3 digit numbers and delimiters)
  int     sample_index = 0;
  int     sample_total = 0;			//remember the last sample saved
 
  int     sync_start = 0;
  int     character;
  int     symbol;
  char    title[80], baud[80],comports[80],stopbit_s[80],parity[80], bitsperbyte_s[80];
  char    soundcard_in_s[80],soundcard_out_s[80],rig_index_s[80],bright_s[80];
  char    screenX_s[80], screenY_s[80], screenW_s[80], screenH_s[80], camera_number_s[80]; //character versions of integers for use in reading the setup file    
 
  char    callsign[80];
  char    CALLSIGN[80];   //for use in SELCAL only
  char    OWN_CALL[80];   //for use in SELCAL only
  static unsigned char call_found[20] ; // MUST be a STATIC UNSIGNED char!!!
  char    filename[256];  //for saving files and reading them via MSG_RX button - up to 256 chars in filename (that should cover it!)
  char    new_filename[256];  //filename after removing the [ and ] brackets around the # message filename
  char    path_plus_filename[256]; //filename with path to shared folder

  char    cq_text[256];
  char    location[256]; 
  char    sounding_message[256];
  char    software_version[256];
  char    input_text[22];       //circular buffer to look back perhaps 20 characters for SELCAL operations
  char*   trigger = ":";        //SELCAL triggers
  static int counter = 0;       //for watchdog timer to ensure we don't keep trying to send a reply ad infinitum  
  unsigned char CRC[3];         //Used to send crc8 as two hex characters
  unsigned char crc;
  unsigned char crc_callfound;
  unsigned char save[80];
  unsigned char SAVECHAR[32000];
  unsigned char SAVEMESSAGE[32000];
  unsigned char Message_buffer[32000];
  unsigned char snr[10];        //Somewhere to save the S/N ratio for use in S/N query

  unsigned char message[1024];  //This is used for short messages in the Alert routine so limit number of chars 

  int   random_seed;    //To randomise the timer in sending back replies at different intervals (can't use Time(NULL) as this is the saem for all PC's with exactly the same time)
                        // So use unique callsign instead

  int bottom_offset;   //To enable resizing of the program window and especially the graphics parts
  int right_offset;

  int Voffset;
  int Hoffset;

  int screenX, screenY, screenW, screenH;  //save these to setup file so that program starts up with window at previous coordinates


		NMHDR *nmptr;
		int tabnumber;


     // Functions in Font.c

  void PopFontInitialize   (HWND) ;
  BOOL PopFontChooseFont   (HWND) ;
  void PopFontSetFont      (HWND) ;
  void PopFontDeinitialize (void) ;


  CHARFORMAT cf;
  float   Signal_to_Noise;
  float   Sig_to_noise;
  float   Signal_to_Noise2;
  float   Sig_to_noise2;
  float   SNR;
  float   sig;
  float   RX_baudrate;

  static float   peaks_count;
  static float   tone_average = 508;
  int     signoise;
  int     signoise2;
  int     squelch_level;
  int     count_peaks;
  int     tone_number;
  int     peak_hits; 
  float   symbol_length = 1.5;  //default baud rate is 4.5, not 6
  int     rig_index;
  int     tone_spacing = 3;
  int     sound_interval = 1800000; //default 30 minute timer for SOUNDer
  int     waterfall_timer = 50;  //update waterfall every 50msec as default
  int     Reply_retries = 10;   //default number of times a reply (eg "ack", SNR etc) is attempted

  static int soundcard_in_ID, soundcard_out_ID; 

  static int comport, baudrate, stopbits, bitsperbyte;

  char    szComportBuffer[256], szRigAddress[256];
  HANDLE  hComm;

  char    synthesizer[33][80];
  byte    hex_TX_command[80];
  byte    hex_RX_command[80];
  char    *text_TX_command;
  char    *text_RX_command;
  char    CAT_tx_file_command[80];  //for reading from setup file
  char    CAT_rx_file_command[80];

  char fullpath[MAX_PATH];
  char fullHeardLogpath[MAX_PATH];
  char full_incoming_path[MAX_PATH];
  char full_image_path[MAX_PATH];
  char full_path_Filesbat[MAX_PATH];
  char full_path_FSQhelp[MAX_PATH];
  char full_path_CALLhelp[MAX_PATH];
  char full_path_TOURhelp[MAX_PATH];
  char full_path_IMAGEhelp[MAX_PATH];
  char full_path_FSQplot[MAX_PATH];
  char full_path_SYNTAXhelp[MAX_PATH];
  char full_path_RULEShelp[MAX_PATH];
  char full_path_Data_txt[MAX_PATH];
  char full_path_TELEMETRYhelp[MAX_PATH]; 

  char FilesShortindexpath[MAX_PATH];
  char FilesLongindexpath[MAX_PATH];
  char Imageindexpath[MAX_PATH];
  char NocallShortpath[MAX_PATH]; 
  char NocallLongpath[MAX_PATH]; 
  char NocallImagespath[MAX_PATH]; 

  long int   NumberofBytes = 0;             //number of bytes to save to wave file

  PortAudioStream   *g_PAStream;
  PortAudioStream   *g_PAStream_Send;


  BOOL   agc                   = TRUE;
  BOOL   agcfast               = FALSE;
  BOOL   agcOFF                = FALSE;
  BOOL   Pause                 = FALSE;
  BOOL   symbol_marker         = TRUE;
  BOOL   Pausebutton           = FALSE;
  BOOL   Synthesizer           = FALSE;
  BOOL   SpectrumAveragebutton = TRUE;
  BOOL   Blue                  = TRUE;
  BOOL   Text_colour           = TRUE; 
  BOOL   Timestamp             = TRUE;
  BOOL   Use_cat               = FALSE;
  BOOL   Use_file_cat_commands = FALSE;
  BOOL   hex_commands          = FALSE;
  BOOL   text_commands         = FALSE;
  BOOL   FSQCAL_CREATE         = TRUE;
  BOOL   FSQCAL                = TRUE;
  BOOL   SOUNDING              = FALSE;
  BOOL   print                 = FALSE;
  BOOL   SAVE_FILE             = FALSE;
  BOOL   MANUAL_SAVE_FILE      = FALSE;
  BOOL   MSGRX                 = FALSE;
  BOOL   OPEN_FILE             = FALSE;
  BOOL   SAVE_MESSAGE          = FALSE;
  BOOL   CALL_FOUND            = FALSE;
  BOOL   fsqcal_active         = TRUE;   
  BOOL   close_squelch         = FALSE;
  BOOL   stop_trigger_search   = FALSE;
  BOOL   cqcqcq_print_on       = TRUE;
  BOOL   ShowMonitor           = TRUE;
  BOOL   sounding_message_on   = FALSE;
  BOOL   AddTimestampandSNR    = FALSE;
  BOOL   Save_RS_data          = FALSE;
  BOOL   save_raw       	   = FALSE;

  const char g_szClassName[] = "FSQ";

  HWND    g_hwndPausebutton, 
          g_hwndCQbutton, 
          g_hwndQTHbutton,
          g_hwndFSQCALbutton, 
          g_hwndSAVEbutton, 
          g_hwndSOUNDINGbutton,
          g_hwndMSGRXbutton,
          g_hwndWaterfall;

  HWND    hwnd,
          hwndList,
		  hwndCommands,
          hwndTab,
          hwndStatic,
          hwndMonitor,
          hwndRXfile,
          hwndSyntax,
          hwndRules,
          hwndSpeed,
          hwndSpeedGraph,
          hwndTrack_brightness,
		  hwndBlank;

  HANDLE  hBitmapRX_ON, 
          hBitmapTX_ON, 
          hBitmapRX_OFF, 
          hBitmapTX_OFF, 
          hBitmapPause_ON, 
          hBitmapPause_OFF,  
          hBitmapSELCAL_ON, 
          hBitmapSELCAL_OFF,
          hBitmapSELCAL_GREEN,
          hBitmapSOUNDING_ON,
          hBitmapSOUNDING_OFF,
          hBitmapSAVE_ON,
          hBitmapSAVE_OFF,
          hBitmapMSGRX_ON,
          hBitmapMSGRX_OFF,
          hBitmapQTC_ON,
          hBitmapQTC_OFF,
          hBitmapQTH_ON,
          hBitmapQTH_OFF;


  HINSTANCE hThisInstance ;
  HINSTANCE g_hInst;
  HWND      hCtl;  
  HWND      hCtl_TX;
     
  HBRUSH    hBrush_listbox;
  HBRUSH    hBrushTab;
  HMENU     menu;                //Handle of the main menu 
  HMENU     hPopMenu ;           //RX screen popup menu
  HMENU		hPopMenuMonitor;     //Monitor screen popup menu
  HMENU		hPopMenuCommands;    //Commands list popup

  HDC       hdcMem, hdcMem2, hdc2, hdcScroll, hEditDC ;
  HBITMAP   hbmMem, hbmMem2, hbmOld,  hbmScroll, hbmScrollOld;





//================================================================================
//  IMAGE MODE VARIABLES THAT ARE COMMON TO IMAGE.C AND THE REST OF THE PROGRAM
//================================================================================
  extern BOOL   Image_mode;
  extern BOOL   PicStart;
  extern BOOL   Sending_pic;
  extern BOOL   Webcam;
  extern BOOL   Remote_webcam;
  extern BOOL   VERYLARGE_PIC;
  extern BOOL   LARGE_PIC;
  extern BOOL   SMALL_PIC;
  extern BOOL   FAX;
  extern BOOL   RXbutton;
  extern BOOL   TXbutton;

  extern void  demodulate_image(float input);
  extern float modulate_image(void);
  extern void  send_pic(void);
  extern void  send_webcam(void);
  extern void  receive_pic(void);
  extern void  Directshow_webcam(void);
  extern void  remote_send_pic(void);

  int   camera_number = 0;
  extern float channel_offset = 350;

  HWND         g_hwndRXbutton, 
               g_hwndTXbutton; 
     
//================================================================================
//                   END OF IMAGE MODE VARIABLES 
//================================================================================



  HPEN      hPen,
            hOldPen,
            hPenSpeed,
            hOldPenSpeed,
            hPenGraph,
            hOldPenGraph,
			hPen6baud,
			hPen45baud,
			hOldPen45baud,
			hPen3baud,
			hOldPen3baud,
			hPen2baud,
			hOldPen2baud;

  PAINTSTRUCT ps;
  RECT      rctClientArea, graph_rect, commands_rect, edit, graphics; 
  int       iXLoop;

  POINT     point ;
  POINT     plotPoints[65536];//NFFTPLOTPOINTS*8]
  int       i; 
  COLORREF  brightness[65536];//NFFTPLOTPOINTS*8];

   
  float     ss, tmp, pk, agc_decay, agcthr, agcgain;
  int       hangcnt, k;  
     
  int       gain,  bright, contrast;



  HFONT     RXfont, Tabfont;
  HFONT     Listfont;
  int       peak_counter, peak_index;

  FILE      *Wavfile;
  FILE      *savefile; //for SELCAL file saving business
  FILE      *heardlog; //for SELCAL received stations log
  FILE      *File_to_send;

  FAR PROC  DefEditProc; //for use in subclassing callsign entry box


static TCHAR szFilter[] = TEXT ("Text Files (*.TXT)\0*.txt\0")  \
                               TEXT ("HTM Files (*.htm)\0*.htm\0") \
                               TEXT ("All Files (*.*)\0*.*\0\0") ;
     
int ChooseFile(HWND hParent, char * sResult)
{  
	sResult[0] = 0;
	OPENFILENAME of;
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize	= sizeof(OPENFILENAME);
	of.hInstance   = g_hInst;
	of.Flags		= OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;
	of.hwndOwner	= hParent;
	of.lpstrFilter	= szFilter;
	//of.lpstrInitialDir = "Setup";
	of.lpstrTitle	= ("Select SMALL text file to send");
	of.lpstrFile			= sResult;
	of.nMaxFile			= MAX_PATH+100;
	of.lpstrCustomFilter	= NULL;
	of.nMaxCustFilter		= 0L;
	if (IDOK == GetOpenFileName(&of))
	{
		return 1;
	}
	return 0;
}

void Start_Portaudio();
void Start_Portaudio_Send();


void ListShortDirectoryContents(const char *sDir, const char *sIndex)  //an example from stackoverflow.com
{
    WIN32_FIND_DATA fdFile;
    HANDLE hFind = NULL;

    char sPath[2048];
    char indexpath[2048];
    FILE* index;

    sprintf(indexpath,"%s", sIndex);
    index = fopen(indexpath, "w");

    //Specify a file mask. *.* = We want everything!
    sprintf(sPath, "%s\\*.*", sDir);

    if((hFind = FindFirstFile(sPath, &fdFile)) == INVALID_HANDLE_VALUE)
    {
      //  printf("Path not found: [%s]\n", sDir);
        return FALSE;
    }

    do
    {
        //Find first file will always return "."
        //    and ".." as the first two directories.
        if(strcmp(fdFile.cFileName, ".") != 0
                && strcmp(fdFile.cFileName, "..") != 0)
        {
            //Build up our file path using the passed in
            //  [sDir] and the file/foldername we just found:
      //      sprintf(sPath, "%s\\%s", sDir, fdFile.cFileName);

            sprintf(sPath, "%s", fdFile.cFileName);
            //Is the entity a File or Folder?
            if(fdFile.dwFileAttributes &FILE_ATTRIBUTE_DIRECTORY)
            {
				fprintf(index,"Folder: %s\n", sPath);
                ListShortDirectoryContents(sPath, indexpath); //Recursion, I love it!
                
            }
            else
			{
			     fprintf(index,"%s\n", sPath); 
            }
        }
    }
    while(FindNextFile(hFind, &fdFile)); //Find the next file.

    FindClose(hFind); //Always, Always, clean things up!
    fclose(index);

    return TRUE;
}

void ListLongDirectoryContents(const char *sDir, const char *sIndex)
{
    WIN32_FIND_DATA fdFile;
    HANDLE hFind = NULL;

	SYSTEMTIME systemTime;

    char sPath[2048];
    char indexpath[2048];
    FILE* index;

    sprintf(indexpath,"%s", sIndex);
    index = fopen(indexpath, "w");

    sprintf(sPath, "%s\\*.*", sDir);

    if((hFind = FindFirstFile(sPath, &fdFile)) == INVALID_HANDLE_VALUE)
    {
        return FALSE;
    }

    do
    {
        if(strcmp(fdFile.cFileName, ".") != 0
                && strcmp(fdFile.cFileName, "..") != 0)
        {
            sprintf(sPath, "%s", fdFile.cFileName);
            if(fdFile.dwFileAttributes &FILE_ATTRIBUTE_DIRECTORY)
            {
				fprintf(index,"\t\t\t\tFolder: %s\n", sPath);
                ListLongDirectoryContents(sPath, indexpath);              
            }
            else
			{
				FileTimeToSystemTime(&fdFile.ftCreationTime, &systemTime);
			    fprintf(index,"%02d-%02d-%d %02d:%02d\t\t%d\t%s\n",systemTime.wDay, systemTime.wMonth, systemTime.wYear, systemTime.wHour, systemTime.wMinute ,fdFile.nFileSizeLow, sPath); //add the file size, assuming it is a small file
            }
        }
    }
    while(FindNextFile(hFind, &fdFile));
 
    FindClose(hFind);
    fclose(index);

    return TRUE;
}



/**************************************************
 Make up a CRC8 table based on the polynomial above
***************************************************/
static void init_crc8()
     /*
      * Should be called before any other crc function.  
      */
{
  int i,j;
  unsigned char crc;

  if (!made_table) {
    for (i=0; i<256; i++) {
      crc = i;
      for (j=0; j<8; j++)
        crc = (crc << 1) ^ ((crc & 0x80) ? DI : 0);   //DI is polynomial 0x07 (see definitions earlier)
      crc8_table[i] = crc & 0xFF;
      /* printf("table[%d] = %d (0x%X)\n", i, crc, crc); */
    }
    made_table=1;
  }
}
/*******************************************************************************/

void remove_char_from_string(char c, char *str) // For use in removing CRLF from callsign box if someone uses ENTER
{                                               // instead of using the mouse to click OK  
    int i=0;
    int len = strlen(str)+1;

    for(i=0; i<len; i++)
    {
        if(str[i] == c)
        {
            // Move all the char following the char "c" by one to the left.
            strncpy(&str[i],&str[i+1],len-i);
        }
    }
}
/*******************************************************************************/

/*******************************************************************************/
/* Write some stuff to the serial port
/*******************************************************************************/
void SerialPuts(HANDLE hComm, void *txstring, int BytesToSend)  //NB. DO NOT use char as *txtstring type!!
{                                                               // othrwise null byte swill truncate the text
	BOOL	        bWriteRC;
	static DWORD	iBytesWritten;

	if(hComm == NULL) return;

	//bWriteRC = WriteFile(hComm, txstring, (DWORD) strlen(txstring), &iBytesWritten,NULL);
    bWriteRC = WriteFile(hComm, txstring, BytesToSend, &iBytesWritten,NULL);
 //   char str[16];
//	sprintf(str,"%d",BytesToSend);
//	remove_char_from_string(0x0, str);  //null
//	SetWindowText(hwnd,str);
	
}
/*******************************************************************************/
/* Initialise the serial port (probably more complex than it needs to be)
/*******************************************************************************/
HANDLE SerialInit(char *ComPortName, DWORD BaudRate, int ByteSize, int StopBit, char ParityChar, char Protocol, int RxTimeOut, int TxTimeOut, int RxBufSize, int TxBufSize) 
{
	HANDLE			hCom;
	BOOL			bPortReady;
	DCB				dcb;
	COMMTIMEOUTS	CommTimeouts;
	int				Parity;

	switch(ParityChar) {
		case 'N':
		case 'n':
			Parity = NOPARITY;
			break;
		case 'E':
		case 'e':
			Parity = EVENPARITY;
			break;
		case 'O':
		case 'o':
			Parity = ODDPARITY;
			break;
		default:
			return NULL;	// illegal parameter !
	}
	
	switch(StopBit)
	{
		case 1:
			StopBit = ONESTOPBIT;
			break;
		case 2:
			StopBit = TWOSTOPBITS;
			break;
		default:
			return NULL;	// illegal parameter !
	}

	hCom = CreateFile(	ComPortName, 
						GENERIC_READ | GENERIC_WRITE,
						0,                 // exclusive access
						NULL,              // no security
						OPEN_EXISTING,
						0,                 // no overlapped I/O
						NULL);             // null template 

	if(hCom == INVALID_HANDLE_VALUE) return NULL;

	bPortReady = SetupComm(hCom, RxBufSize, TxBufSize); // set Rx and Tx buffer sizes

	// Port settings are specified in a Data Communication Block (DCB). 

	bPortReady = GetCommState(hCom, &dcb);

	dcb.BaudRate	= BaudRate;
	dcb.ByteSize	= ByteSize;
	dcb.Parity		= Parity;
	dcb.StopBits	= StopBit;
	dcb.fAbortOnError = TRUE;

	switch(Protocol) {
	case 'D':	// DTR/DSR
	case 'd':
		// set XON/XOFF
		dcb.fOutX	= FALSE;
		dcb.fInX	= FALSE;
		// set RTSCTS
		dcb.fOutxCtsFlow = FALSE;
		dcb.fRtsControl = RTS_CONTROL_DISABLE; 
		// set DSRDTR
		dcb.fOutxDsrFlow = TRUE;
		dcb.fDtrControl = DTR_CONTROL_HANDSHAKE; 
		break;
	case 'R':	// RTS/CTS
	case 'r':
		// set XON/XOFF
		dcb.fOutX	= FALSE;
		dcb.fInX	= FALSE;
		// set RTSCTS
		dcb.fOutxCtsFlow = TRUE;
		dcb.fRtsControl = RTS_CONTROL_HANDSHAKE; 
		// set DSRDTR
		dcb.fOutxDsrFlow = FALSE;
		dcb.fDtrControl = DTR_CONTROL_DISABLE; 
		break;
	case 'X':	// XON/XOFF
	case 'x':
		// set XON/XOFF
		dcb.fOutX	= TRUE;
		dcb.fInX	= TRUE;
		dcb.fTXContinueOnXoff = TRUE;
		dcb.XoffChar = ASCII_XOFF;
		dcb.XoffLim = RxBufSize - (RxBufSize / 4);
		dcb.XonChar = ASCII_XON;
		dcb.XonLim = RxBufSize - (RxBufSize / 2);
		// set RTSCTS
		dcb.fOutxCtsFlow = FALSE;
		dcb.fRtsControl = RTS_CONTROL_DISABLE; 
		// set DSRDTR
		dcb.fOutxDsrFlow = FALSE;
		dcb.fDtrControl = DTR_CONTROL_DISABLE;
		break;
	case 'N':	// NOPROTOCOL
	case 'n':
	default:
		// set XON/XOFF
		dcb.fOutX	= FALSE;
		dcb.fInX	= FALSE;
		// set RTSCTS
		dcb.fOutxCtsFlow = FALSE;
		dcb.fRtsControl = RTS_CONTROL_DISABLE; 
		// set DSRDTR
		dcb.fOutxDsrFlow = FALSE;
		dcb.fDtrControl = DTR_CONTROL_DISABLE; 
		break;
	}

	bPortReady = SetCommState(hCom, &dcb);

	// Set timeouts
	CommTimeouts.ReadIntervalTimeout = RxTimeOut;
	CommTimeouts.ReadTotalTimeoutMultiplier = 0;
	CommTimeouts.ReadTotalTimeoutConstant = RxTimeOut;

	CommTimeouts.WriteTotalTimeoutMultiplier = 0;
	CommTimeouts.WriteTotalTimeoutConstant = TxTimeOut;

	bPortReady = SetCommTimeouts(hCom, &CommTimeouts);

	return hCom;
}

/*******************************************************************************/
/*******************************************************************************/
static LRESULT CALLBACK SOUNDCARDDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
   Pa_Terminate();
   Pa_Initialize();

   char     szTemp[256];


    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
  		      int      i;
              int      numDevices;
              const    PaDeviceInfo *pdi;

              numDevices = Pa_CountDevices();                       //Total number of input and output channels

            for( i=0; i <  numDevices; i++)//pdi->maxInputChannels+1; i++)              //Look for input channels
                {
                    pdi = Pa_GetDeviceInfo( i );
             	   // if(pdi->maxInputChannels > 0)
                       {   
			    	    wsprintf(szTemp,"%s", pdi->name);
				        SendMessage(GetDlgItem(hwndDlg,IDM_SOUNDCARD_IN), CB_ADDSTRING, 0, (LPARAM)szTemp);
             

				        //Select the item in combobox that is the desired soundcard input device
				        SendMessage(GetDlgItem(hwndDlg,IDM_SOUNDCARD_IN), CB_SETCURSEL, soundcard_in_ID, 0);			

                        //make sure the window stays on top 
                        SetWindowPos (hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE); 
                       } 
			    }

             for( i=0; i < numDevices; i++)    //Now assume the rest are all outputs
                {                                                   //Can't use for( i=0; i< pdi->maxInputChannels+1; i++) for some reason
                    pdi = Pa_GetDeviceInfo( i );
            	 //   if(pdi->maxOutputChannels > 0)
                       {   
			    	    wsprintf(szTemp,"%s", pdi->name);
				        SendMessage(GetDlgItem(hwndDlg,IDM_SOUNDCARD_OUT), CB_ADDSTRING, 0, (LPARAM)szTemp);
               

				        //Select the item in combobox that is the desired soundcard output device
				        SendMessage(GetDlgItem(hwndDlg,IDM_SOUNDCARD_OUT), CB_SETCURSEL, soundcard_out_ID, 0);			

                        //make sure the window stays on top 
                        SetWindowPos (hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE); 
                       } 
 
   			    }	
			}
			break;
	

		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
 
     		 case IDC_CANCEL:
                 EndDialog(hwndDlg, 0);
				break;  
    	
     		 case IDOK:
       
                  soundcard_in_ID  = SendMessage(GetDlgItem(hwndDlg,IDM_SOUNDCARD_IN),CB_GETCURSEL,0,0);
                  SendMessage(GetDlgItem(hwndDlg,IDM_SOUNDCARD_IN),CB_GETLBTEXT,soundcard_in_ID, (LPARAM)szTemp);

                  soundcard_out_ID = SendMessage(GetDlgItem(hwndDlg,IDM_SOUNDCARD_OUT),CB_GETCURSEL,0,0);
                  SendMessage(GetDlgItem(hwndDlg,IDM_SOUNDCARD_OUT),CB_GETLBTEXT,soundcard_out_ID, (LPARAM)szTemp);

      Start_Portaudio();                    //Start receiver
      Pa_StopStream (g_PAStream);           //temporarily stop receiver to avoid screen flicker 
                                            //when starting sender 

      Start_Portaudio_Send();               //Start sender
      Pa_StopStream (g_PAStream_Send);      //Stop sender until needed later

      Pa_StartStream (g_PAStream);          //Restart receiver




 
                  SetFocus (hCtl_TX);   //Put focus back to send box
  
                 EndDialog(hwndDlg, 0);
				break;

            }
            break;

        case WM_CLOSE:

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}
/*******************************************************************************/
/*******************************************************************************/

static LRESULT CALLBACK PTTDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

//This sets up the comport for the PTT line
//Uses RTS and DTR just in case there are differences in rigs

    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
  		      int i;			 
              char szTemp[256], szTempRig[256];

        //Set the PTT/CAT radiobutton to the chosen one
              if((Use_cat == FALSE)&(Use_file_cat_commands == FALSE))SendMessage(GetDlgItem(hwndDlg,IDM_USE_PTT), BM_SETCHECK, 1, 0);
              if((Use_cat == TRUE)&(Use_file_cat_commands == FALSE)) SendMessage(GetDlgItem(hwndDlg,IDM_USE_CAT), BM_SETCHECK, 1, 0);
              if((Use_cat == TRUE)&(Use_file_cat_commands == TRUE)) SendMessage(GetDlgItem(hwndDlg,IDM_USE_FILE_COMMAND), BM_SETCHECK, 1, 0);  
			 

        //Populate the comobobox with all possible comports (no longer used)
            //  for(i=0;i<100;i++)               
			//   {
			//	wsprintf(szTemp,"%s%d", "COM",i);
			//	SendMessage(GetDlgItem(hwndDlg,IDM_PTT), CB_ADDSTRING, 0, (LPARAM)szTemp);
            //   }
			

// Parse the registry to find out what COM ports are available (the "official" way to do it!)

  int   numports = 0;
  HKEY  Key;
  DWORD Length, DataLength;
  char  Buffer[MAX_PATH + 1];
  BYTE  Data[MAX_PATH + 1];
  BOOL  Result = TRUE;
 
  if ( RegCreateKey( HKEY_LOCAL_MACHINE, TEXT("HARDWARE\\Devicemap\\SerialComm"), &Key ) != ERROR_SUCCESS )
  {
    MessageBox(hwnd,"No comports","Comport error",MB_OK);
  }

  while ( Result )
  {
    Length     = sizeof( Buffer );
    DataLength = sizeof( Data );
    if ( RegEnumValue( Key, numports, Buffer, &Length, NULL, NULL, Data, &DataLength ) != ERROR_SUCCESS )
    {
      Result = FALSE;
    }
    else
    {
            wsprintf(szTemp,"%s",Data);
            SendMessage(GetDlgItem(hwndDlg,IDM_PTT), CB_ADDSTRING, 0, (LPARAM)szTemp);
      numports++;
    }
  }


//List only those comports that are available (this is extremely dodgy!)
/*HANDLE hcomm;
int error;
              for(i=1;i<256;i++)               
			   {
				wsprintf(szTemp,"%s%d", "COM",i);
		        
              //Try to open the comport
	            hcomm = CreateFile(	szTemp, 
						GENERIC_READ | GENERIC_WRITE,
						0,                 // exclusive access
						NULL,              // no security
						OPEN_EXISTING,
						0,                 // no overlapped I/O
						NULL);             // null template 
endif:
	           if(hcomm == INVALID_HANDLE_VALUE)     
                       {
                        error=GetLastError();
             //check to see if the error was because some other app had the port open
                        if(error == ERROR_ACCESS_DENIED)
					          {
					           wsprintf(szTemp,"%s%d", "COM",i);
				               SendMessage(GetDlgItem(hwndDlg,IDM_PTT), CB_ADDSTRING, 0, (LPARAM)szTemp);//keep this one even if it is in use
					           // MessageBox(hwnd,"Comport in use","",MB_OK);	
				              }  
            //now check to see if the error was because of a general failure
                       if(error == ERROR_ACCESS_DENIED | error == ERROR_GEN_FAILURE | error == ERROR_SHARING_VIOLATION)goto endif; //discard these
                                                                                         

			                  }
                       else
			                  {
			//Add it to the list
			                   SendMessage(GetDlgItem(hwndDlg,IDM_PTT), CB_ADDSTRING, 0, (LPARAM)szTemp);  
                               CloseHandle(hcomm);	                    //Don't forget to close the port ready for the next try
			                  }            
			   }
*/

		//Select the item in combobox that is the desired comport number (no longer used - superseded by the new method below)
		//		SendMessage(GetDlgItem(hwndDlg,IDM_PTT), CB_SETCURSEL, comport, 0);  //this gets whatever is selected manually from the listbox (but doesn't get the comport from the setup file anymore)


       //Select the item in combobox that matches the one in the setup file

		      //But first remove any prepended "\\.\" so that CB_GETLBTEXT can recognise the plain text COMn in the combobox
                remove_char_from_string(0x5C, comports);  // "\"
                remove_char_from_string(0x2E, comports);  // "."
                remove_char_from_string(0x5C, comports);  // "\"

                comport = SendMessage(GetDlgItem(hwndDlg,IDM_PTT), CB_SELECTSTRING, 0, (LPARAM)comports);  //Find it
                SendMessage(GetDlgItem(hwndDlg,IDM_PTT), CB_SETCURSEL, comport, 0);                        //Select it
  
        //Now do the same with the comobobox with ICOM rigs and addresses
                  
                wsprintf(szTempRig,"%s", "66,ICOM 746PRO");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "56,ICOM 746");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "5C,ICOM 756PRO");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "64,ICOM 756PRO II");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s",  "6E,ICOM 756PRO III");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "88,ICOM 7100");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "76,ICOM 7200");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s",  "6A,ICOM 7800");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s",  "70,ICOM 7000");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "7A,ICOM 7600");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "74,ICOM 770");
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "80,ICOM 7410");

				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "00,Kenwood (older models)");

				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "01,Kenwood (newer models)");

				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "02,Yaesu (FTDX3000 etc)");

				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "03,Yaesu (FT1000 etc)");

				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                wsprintf(szTempRig,"%s", "04,Yaesu (FT847 etc)");

				
				SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_ADDSTRING, 0, (LPARAM)szTempRig);
                SendMessage(GetDlgItem(hwndDlg,IDM_CAT), CB_SETCURSEL, rig_index, 0);		


               //make sure the window stays on top while we do all of this
                SetWindowPos (hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);   
   				
			}
			break;
	

		 case WM_COMMAND:
			
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
 
     		 case IDC_CANCEL:
                 EndDialog(hwndDlg, 0);
				break;  
                  
             case IDM_USE_CAT:  
                  {Use_cat = TRUE;
				   Use_file_cat_commands = FALSE;}                   
                  return 0;

             case IDM_USE_PTT:  
                  {Use_cat = FALSE;
				   Use_file_cat_commands = FALSE;}
                  return 0;

            case IDM_USE_FILE_COMMAND:
                  {Use_cat = TRUE;                 //tell the system we are still using CAT rather than hardware PTT
				   Use_file_cat_commands = TRUE;}  //send CAT command from setup file entry
                                  
				  return 0;

             
     		 case IDOK:
                 {
			      //Get the comport

                  comport = SendMessage(GetDlgItem(hwndDlg,IDM_PTT),CB_GETCURSEL,0,0);
                  SendMessage(GetDlgItem(hwndDlg,IDM_PTT),CB_GETLBTEXT,comport, (LPARAM)szComportBuffer);

                 // Add in support for higher than COM9 serial ports (virtual comports) ie. add "\\.\" in front of normal COMnn

			      sprintf_s(comports, sizeof(comports), "\\\\.\\%s", szComportBuffer );  //Note: double "\\" equals a single "\" (escape sequence), so "\\\\.\\" is actually "\\.\" 
                                                                                           //We can also add \\.\ to the lower comports with no problems - makes the code simpler
                  CloseHandle(hComm);               //close the comport(?) in case it is open

                  hComm = SerialInit(comports, baudrate, bitsperbyte, stopbits, parity[0], 'N', 50, 50, 512, 512) ;
              //   hComm = SerialInit( szComportBuffer, baudrate, bitsperbyte, stopbits, parity[0], 'N', 50, 50, 512, 512) ;
                  if (hComm == NULL)//INVALID_HANDLE_VALUE)
                      {
                        MessageBox(0,"Comport already open or no comport available","Comport Error",0);   //error occured alert user about error
                        return -1;
                      }
                 if (EscapeCommFunction(hComm,CLRDTR) == 0)              //clear RTS and DTR
                        MessageBox(0,"Error Clearing DTR","Comport Error",0); //should never get here but, just in case..

                 if (EscapeCommFunction(hComm,CLRRTS) == 0) 
                        MessageBox(0,"Error Clearing CTS","Comport Error",0);


					       
                //Now select the rig address for use in CAT control
                 
                  rig_index = SendMessage(GetDlgItem(hwndDlg,IDM_CAT),CB_GETCURSEL,0,0);
                  SendMessage(GetDlgItem(hwndDlg,IDM_CAT),CB_GETLBTEXT, rig_index, (LPARAM)szRigAddress);

                                     
				//Get rig address (in hex) from combobox listing (the first two characters)
					char rig_address[2];
	                memcpy(rig_address, szRigAddress, 2);
                    rig_address[2] = '\0';    //Avoid rubbish after first character (is this needed here?)
                                              //Note: we can use  szRigAddress and it also seems to work!
   
	                unsigned long n = strtoul( rig_address, 0, 16 ); // convert from hex, assuming null-terminated string


         //      sprintf(Hex_address,"%c",n);   //turn the decimal  value into a character, using %c


 //PTT on/off
       if(n > 0x50)                          //ICOM rigs using hex arrays
			  {
			   hex_commands  = TRUE;     //tell the TX and RX routines which one to send
			   text_commands = FALSE;

               hex_TX_command[0] = 0xFE;                 
               hex_TX_command[1] = 0xFE;
               hex_TX_command[2] = n;
               hex_TX_command[3] = 0xE0;
               hex_TX_command[4] = 0x1C;
               hex_TX_command[5] = 0x00;
               hex_TX_command[6] = 0x01;
               hex_TX_command[7] = 0xFD;   

               hex_RX_command[0] = 0xFE;
               hex_RX_command[1] = 0xFE;
               hex_RX_command[2] = n;
               hex_RX_command[3] = 0xE0;
               hex_RX_command[4] = 0x1C;
               hex_RX_command[5] = 0x00;
               hex_RX_command[6] = 0x00;
               hex_RX_command[7] = 0xFD;
              }

		if(n==0)                            //Other rigs using text commands
		      {
			   text_commands = TRUE;
			   hex_commands  = FALSE;

               text_TX_command   = "TX;";       //TX; = Kenwood (older models) 
               text_RX_command   = "RX;";       //RX; = Kenwood
              }    

		if(n==1)                            
		      {
			   text_commands = TRUE;
			   hex_commands  = FALSE;

               text_TX_command   = "TX1;";       //TX; = Kenwood (newer models) 
               text_RX_command   = "RX;";        //RX;
              }    

       if(n == 2)
		      {
			   text_commands = TRUE;
			   hex_commands  = FALSE;

               text_TX_command   = "TX1;";       //TX1; = Yaesu (FTDX3000 etc)   
               text_RX_command   = "TX0;";       //TX0; 
              }    

       if(n == 3)
		      {
			   text_commands = FALSE;            //Yaesu (FT1000 etc)
			   hex_commands  = TRUE;

               hex_TX_command[0] = 0x00;
               hex_TX_command[1] = 0x00;
               hex_TX_command[2] = 0x00;
               hex_TX_command[3] = 0x01;
               hex_TX_command[4] = 0x0F;

               hex_RX_command[0] = 0x00;
               hex_RX_command[1] = 0x00;
               hex_RX_command[2] = 0x00;
               hex_RX_command[3] = 0x00;
               hex_RX_command[4] = 0x0F;   
              }    

       if(n == 4)
		      {
			   text_commands = FALSE;            //Yaesu (FT847 etc)
			   hex_commands  = TRUE;

               hex_TX_command[0] = 0x00;
               hex_TX_command[1] = 0x00;
               hex_TX_command[2] = 0x00;
               hex_TX_command[3] = 0x00;
               hex_TX_command[4] = 0x08;

               hex_RX_command[0] = 0x00;
               hex_RX_command[1] = 0x00;
               hex_RX_command[2] = 0x00;
               hex_RX_command[3] = 0x00;
               hex_RX_command[4] = 0x88; 
              } 
   



/***************************************
YAESU
FTDX3000,"TX1;","TX0;",38400,1
FTDX1200,"TX1;","TX0;",38400,1
FT5000,  "TX1;","TX0;",38400,1
FT2000,  "TX1;","TX0;",4800, 1
FT950,   "TX1;","TX0;",38400,1
FT450,   "TX1;","TX0;",4800, 1

FT100D,  ...0x01 0x0F, ...0x00 0x0F,4800,2
FT1000,  ...0x01 0x0F, ...0x00 0x0F,4800,2
FT1000MP,...0x01 0x0F, ...0x00 0x0F,4800,2
FT990,   ...0x01 0x0F, ...0x00 0x0F,4800,2    00 00 00 01.0F   ?
FT890,   ...0x01 0x0F, ...0x00 0x0F,4800,2
FT747,   ...0x01 0x0F, ...0x00 0x0F,4800,2

FT817,   ...0x00 0x08, ...0x00 0x88,4800,2    00 00 00 00.08
FT847,   ...0x00 0x08, ...0x00 0x88,9600,2
FT857D,  ...0x00 0x08, ...0x00 0x88,4800,2
//****************************************
KENWOOD
TS140,  "TX;","RX;",9600, 2
TS450,  "TX;","RX;",4800, 2
TS570,  "TX;","RX;",4800, 2
TS870S, "TX;","RX;",57600,1
TS2000, "TX;","RX;",4800, 2

TS480,  "TX1;","RX",4800, 2  (data mode)
TS480,  "TX0;","RX",4800, 2  (mic input)

TS590S, "TX1;","RX",115200,1  (data mode)
TS590S, "TX0;","RX",115200,1  (mic input)

TS990,  "TX1;","RX",115200,1  (data mode)
TS990,  "TX0;","RX",115200,1  (mic input)
//******************************************

TENTEC
TT516, "TT516setXMT","TT516setRCV", 1200, 1
TT538, "TT538setXMT","TT538setRCV", 57600,2
TT550, "TT550setXMT","TT5550setRCV",57600,2
TT563, "TT563setXMT","TT563setRCV", 9600, 1
//*******************************************
ELECRAFT
K2, "TX;","RX;",4800, 2
K3, "TX;","RX;",38400,1
//********************************************
*/


      		 
                 SetFocus (hCtl_TX);   //Put focus back to send box

                 EndDialog(hwndDlg, 0);
		         }
				break;

            }
            break;

        case WM_CLOSE:

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}
/*******************************************************************************/

/*******************************************************************************/


static LRESULT CALLBACK CallsignDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

//
//
 int l;
    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
			    SetFocus (GetDlgItem(hwndDlg,IDM_CALLSIGN));

               //make sure the window stays on top 
                SetWindowPos (hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);   
   				SetWindowText(GetDlgItem(hwndDlg,IDM_CALLSIGN), callsign); 
			}
			break;
	

		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
            
     		 case IDC_CANCEL:
                 EndDialog(hwndDlg, 0);
				break;  
    	
     		 case IDOK:
               
                {    


                 int txtlen=GetWindowTextLength(GetDlgItem(hwndDlg,IDM_CALLSIGN));
                 GetWindowText(GetDlgItem(hwndDlg,IDM_CALLSIGN), callsign, txtlen+1);

                 remove_char_from_string(0xA, callsign);  //CR
                 remove_char_from_string(0xD, callsign);  //LF

                 SetFocus (hCtl_TX);   //Put focus back to send box

                 EndDialog(hwndDlg, 0);
				
				break;
                }

		    }
            break;

        case WM_CLOSE:

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}

/*******************************************************************************/
/* Input box for QTC button
/*******************************************************************************/
static LRESULT CALLBACK QTCmessageDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
 int l;
    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
			    SetFocus (GetDlgItem(hwndDlg,IDM_QTC));

               //make sure the window stays on top 
                SetWindowPos (hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);   
   				SetWindowText(GetDlgItem(hwndDlg,IDM_QTC), cq_text); 
			}
			break;
	

		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
            
     		 case IDC_CANCEL:
                 EndDialog(hwndDlg, 0);
				break;  
    	
     		 case IDOK:
               
                {    


                 int txtlen=GetWindowTextLength(GetDlgItem(hwndDlg,IDM_QTC));
                 GetWindowText(GetDlgItem(hwndDlg,IDM_QTC), cq_text, txtlen+1);

                 remove_char_from_string(0xA, cq_text);  //CR
                 remove_char_from_string(0xD, cq_text);  //LF

                 SetFocus (hCtl_TX);   //Put focus back to send box

                 EndDialog(hwndDlg, 0);
				
				break;
                }

		    }
            break;

        case WM_CLOSE:

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}


/*******************************************************************************/
/* Input box for Location (QTH)
/*******************************************************************************/
static LRESULT CALLBACK QTHDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
 int l;
    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
			    SetFocus (GetDlgItem(hwndDlg,IDM_QTH));

               //make sure the window stays on top 
                SetWindowPos (hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);   
   				SetWindowText(GetDlgItem(hwndDlg,IDM_QTH), location); 
			}
			break;
	

		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
            
     		 case IDC_CANCEL:
                 EndDialog(hwndDlg, 0);
				break;  
    	
     		 case IDOK:
               
                {    


                 int txtlen=GetWindowTextLength(GetDlgItem(hwndDlg,IDM_QTH));
                 GetWindowText(GetDlgItem(hwndDlg,IDM_QTH), location, txtlen+1);

                 remove_char_from_string(0xA, location);  //CR
                 remove_char_from_string(0xD, location);  //LF

                 SetFocus (hCtl_TX);   //Put focus back to send box

                 EndDialog(hwndDlg, 0);
				
				break;
                }

		    }
            break;

        case WM_CLOSE:

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}
/*******************************************************************************/
/* Input box for Location (QTH)
/*******************************************************************************/
static LRESULT CALLBACK SoundingMessageDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
 int l;
    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
			    SetFocus (GetDlgItem(hwndDlg,IDM_SOUNDING_MESSAGE));

               //make sure the window stays on top 
                SetWindowPos (hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);   
   				SetWindowText(GetDlgItem(hwndDlg,IDM_SOUNDING_MESSAGE), sounding_message); 
			}
			break;
	

		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
            
     		 case IDC_CANCEL:
                 EndDialog(hwndDlg, 0);
				break;  
    	
     		 case IDOK:
               
                {    


                 int txtlen=GetWindowTextLength(GetDlgItem(hwndDlg,IDM_SOUNDING_MESSAGE));
                 GetWindowText(GetDlgItem(hwndDlg,IDM_SOUNDING_MESSAGE), sounding_message, txtlen+1);

                 remove_char_from_string(0xA, location);  //CR
                 remove_char_from_string(0xD, location);  //LF

                 SetFocus (hCtl_TX);   //Put focus back to send box

                 EndDialog(hwndDlg, 0);
				
				break;
                }

		    }
            break;

        case WM_CLOSE:

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}
/*******************************************************************************/
/* ALERT box
/*******************************************************************************/
static LRESULT CALLBACK ALERTDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
 int l;
    switch (uMsg)
    {
        case WM_INITDIALOG:
			{
			    SetFocus (GetDlgItem(hwndDlg,IDM_ALERT));

               //make sure the window stays on top 
                SetWindowPos (hwndDlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);   

                SYSTEMTIME time_stamp;
                GetLocalTime(&time_stamp);            
           					   			
                unsigned char alert[1100];
                sprintf(alert, "%s %02d/%02d/%02d, %02d:%02d, %s%s%s","At ",time_stamp.wDay, time_stamp.wMonth, time_stamp.wYear,time_stamp.wHour, time_stamp.wMinute,call_found," sent:",message);
                SetWindowText(GetDlgItem(hwndDlg,IDM_ALERT), alert);

			}
			break;
	

		 case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam, lParam))
            {				
            
     		 case IDC_CANCEL:
                 EndDialog(hwndDlg, 0);
				break;  
    	
     		 case IDOK:
               
                {    

                 SetFocus (hCtl_TX);   //Put focus back to send box

                 EndDialog(hwndDlg, 0);
				
				break;
                }

		    }
            break;

        case WM_CLOSE:

            EndDialog(hwndDlg, 0);			
            return TRUE;
		 }

    return FALSE;
}
//
//Send Textbox's subclassed message handler (to send button click to send/recv control)
//

LRESULT CALLBACK MyEditProc(HWND hDlg, UINT message,WPARAM wParam, LPARAM lParam) 
{
	
   switch(message) {
     case WM_CHAR:
        if( wParam == 13 ) //ENTER key
				{
                PostMessage(g_hwndTXbutton, WM_LBUTTONDOWN, 0, 0) ;  //start sending
                SetFocus(hCtl_TX);      
                return(0);
                }
        if( wParam == 27 ) //ESC key
				{
                PostMessage(g_hwndRXbutton, WM_LBUTTONDOWN, 0, 0) ;  //start receiving, if needed for emergency purposes
                SetFocus(hCtl_TX);      
                return(0);
                }
        if(Sending_pic == TRUE)return 0;                            //prevent typing in send box while a picture is being sent

        else return( (LRESULT)CallWindowProc ((WNDPROC)DefEditProc,hDlg,message,wParam,lParam) );
             break;
        default:
             return( (LRESULT)CallWindowProc((WNDPROC)DefEditProc, hDlg,message,wParam,lParam) );
             break;
                   }
   return(0);
}
//


//
// Functions for reading in an entire RTF file into a richedit control (Syntax and Rules tabs)  --Not used anymore - now loaded from resource
//
DWORD CALLBACK EditStreamCallback(DWORD_PTR dwCookie, LPBYTE lpBuff,
                                  LONG cb, PLONG pcb)
{
 HANDLE hFile = (HANDLE)dwCookie;
 return !ReadFile(hFile, lpBuff, cb, (DWORD *)pcb, NULL);
}


BOOL FillRichEditFromFile(HWND hwnd, LPCTSTR pszFile)
{
 BOOL fSuccess = FALSE;
 HANDLE hFile = CreateFile(pszFile, GENERIC_READ, FILE_SHARE_READ,
                           0, OPEN_EXISTING,
                           FILE_FLAG_SEQUENTIAL_SCAN, NULL);
 if (hFile != INVALID_HANDLE_VALUE) {
  EDITSTREAM es = { (DWORD_PTR)hFile, 0, EditStreamCallback };
  if (SendMessage(hwnd, EM_STREAMIN, SF_RTF, (LPARAM)&es) &&
      es.dwError == 0) {
   fSuccess = TRUE;
  }
  CloseHandle(hFile);
 }
 return fSuccess;
}
//
void Thread (PVOID pvoid)
{

  DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_ALERT), NULL, (DLGPROC)ALERTDlgProc);
 //    MessageBox(hwnd,message,"- ALERT -",MB_OK | MB_SETFOREGROUND | MB_ICONEXCLAMATION);
             
 

					                 KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
	                
					                 unsigned char reply[20]="";           //Another in which to put the received callsign  
                                     sprintf(reply, " %s", "Alert ack");    //need to do this to ensure a space after the callsign 
				
                                     int lg2;
			                    
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     lg2 = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, lg2, (LPARAM)reply); 
    
                                     srand (time(NULL));                                   //randomise the random number generator						 
 					                 SetTimer(hwnd, 1, (rand() % 1000)+1000, NULL);        //Start a random 1 second timer and then TX after squelch has closed    
     _endthread () ;
}
//
void Use_file_commands(void)
{
     if(Use_file_cat_commands == TRUE)
      {
//Check to see if the CAT commands are in text or hex format
       char *cset = "0123456789ABCDEF";  //If there are any characters not in this set then we have a text command (don't use char cset[]="0123..."
       int seek;

//Check first for TX commands
       seek = strcspn (CAT_tx_file_command,cset);
	   if(seek == strlen(CAT_tx_file_command))
			{
			 text_TX_command = CAT_tx_file_command;        //text command
             text_commands   = TRUE;
			 hex_commands    = FALSE;
			}
       if(seek != strlen(CAT_tx_file_command))             //hex command
			{
             unsigned char hexbyte[2] = {'\0','\0'} ;  
             unsigned int num;
//Clear the  hex_TX_command array of previous entries

             for( int i = 0; i < 80; i++ ) hex_TX_command[i] = '\0';

//Now parse the command string and send each hex doublet out as a character

             for( int d = 0; d < strlen(CAT_tx_file_command); d += 2 )
               {
             // Assemble a digit pair into the hexbyte string
                 hexbyte[0] = CAT_tx_file_command[d] ;
                 hexbyte[1] = CAT_tx_file_command[d+1] ;
 
             // Convert the hex pair to an integer 
                 num = strtoul(hexbyte,0,16);

             // Add it to the command string        
                 hex_TX_command[d/2] = num;
               }
               text_commands = FALSE;
		       hex_commands  = TRUE;
            }
 	//MessageBox(hwnd,text_TX_command,"",MB_OK);

//Now repeat for the CAT RX commnands

       seek = strcspn (CAT_rx_file_command,cset);
	   if(seek == strlen(CAT_rx_file_command))
			{
			 text_RX_command = CAT_rx_file_command;        //text command
             text_commands   = TRUE;
		     hex_commands    = FALSE;
			}
       if(seek != strlen(CAT_rx_file_command))             //hex command
			{
             unsigned char hexbyte[2] = {'\0','\0'} ;  
             unsigned int num;
//Clear the  hex_RX_command array of previous entries

             for( int i = 0; i < 80; i++ ) hex_RX_command[i] = '\0';

//Now parse the command string and send each hex doublet out as a character

             for( int d = 0; d < strlen(CAT_rx_file_command); d += 2 )
               {
             // Assemble a digit pair into the hexbyte string
                 hexbyte[0] = CAT_rx_file_command[d] ;
                 hexbyte[1] = CAT_rx_file_command[d+1] ;
 
             // Convert the hex pair to an integer 
                 num = strtoul(hexbyte,0,16);

             // Add it to the command string        
                 hex_RX_command[d/2] = num;
               }
               text_commands = FALSE;
		       hex_commands  = TRUE;
            }

 //	MessageBox(hwnd,hex_RX_command,"",MB_OK);
      }
}
//

//===============================================================================================
//Fast attack-slow decay for squelch (also not used anymore)

#define TIME         0.9999     // integrator time constant
#define ATTENUATION  0.05       // attenuation after integ.
#define OUTGAIN      1.66       // output gain boost
void normalize(int sample_len, float x[], float y[])
{
  double energy, integr, prev_in, gain;
  int t;

  prev_in = x[i];                  // setup for first time
  for(t = 0; t < sample_len; t++)
  {
    energy = abs( x[t] );          // rectifier
    integr = TIME*prev_in + (1-TIME)*energy;    // integration
    prev_in = integr;              //  y(t-1)
    gain = 1.0 / integr;           // inversion
    gain = gain * ATTENUATION;     // attenuate too big gain
    if(gain > 1.0) gain = 1.0;     // limit below 1.0
    y[t] = gain * x[t];            // vca
    y[t] = OUTGAIN * y[t];         // boost
  }
}
//===============================================================================================

// Description:
//   Creates a tooltip for an item in a dialog box. 
// Parameters:
//   idTool - identifier of an dialog box item.
//   nDlg - window handle of the dialog box.
//   pszText - string to use as the tooltip text.
// Returns:
//   The handle to the tooltip.
//
HWND CreateToolTip(int toolID, HWND hDlg, PTSTR pszText)
{
    if (!toolID || !hDlg || !pszText)
    {
        return FALSE;
    }
    // Get the window of the tool.
    HWND hwndTool = GetDlgItem(hDlg, toolID);
    
    // Create the tooltip. g_hInst is the global instance handle.
    HWND hwndTip = CreateWindowEx(0, TOOLTIPS_CLASS, NULL,
                              WS_POPUP |TTS_ALWAYSTIP | TTS_BALLOON,
                              CW_USEDEFAULT, CW_USEDEFAULT,
                              CW_USEDEFAULT, CW_USEDEFAULT,
                              hDlg, NULL, 
                              g_hInst, NULL);
    
   if (!hwndTool || !hwndTip)
   {
       return (HWND)NULL;
   }                              
                              
    // Associate the tooltip with the tool.
    TOOLINFO toolInfo = { 0 };
    toolInfo.cbSize = sizeof(toolInfo);
    toolInfo.hwnd = hDlg;
    toolInfo.uFlags = TTF_IDISHWND | TTF_SUBCLASS;
    toolInfo.uId = (UINT_PTR)hwndTool;
    toolInfo.lpszText = pszText;

    SendMessage(hwndTip, TTM_SETMAXTIPWIDTH, 0, (LPARAM)220);
    SendMessage(hwndTip, TTM_ADDTOOL, 0, (LPARAM)&toolInfo);

    return hwndTip;
}


/*-----------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
 *
 *      Receive audio stream callback function
 *
 *      All receive audio processing is done in this function!
 *
 *      (No need to mess with a separate worker thread since this is
 *      already taken care of by PortAudio!)
 */

static int AudioCallback (void *inputBuffer,
                          void *outputBuffer,
                          unsigned long framesPerBuffer,
                          PaTimestamp outTime,
                          void *userData)
{
  unsigned long frameCnt;
  float         *out = (float *) outputBuffer;
  float         *in  = (float *) inputBuffer;
  float         leftInput;
  float         rightInput;

  float         rI44k;
  float         rI11k;
  float         rQ44k;
  float         rQ11k; 

  float         rTmp, rTmpSpeed;
  float         re,im, reSpeed, imSpeed;
  float         gainf;
  int           i, j;
  static int    k, m;

 static float rLocalOscPhAcc;

  static int    iFftBufIdxIn = 0;
  static unsigned int ui44kSampleCounter = 0;

  static int    iDecimatorIdxIn = 0;
  static float  rDecimatorQueueI[64];
  static float  rDecimatorQueueQ[64];

  int           spec_ave, peak_smooth;

  static int    peak_val, prev_peak, peak_valSpeed, prev_peakSpeed ;
  static int    prev_symbol;
	

  static int    peak_counter, speed_counter;  
  int           peak = 0;
  int           peakSpeed = 0;

  double        val, max = 0.0;
  double        valSpeed, maxSpeed = 0.0;
  static int    last_peak;
  int           nibble;
  static int    MSB, LSB;

  static int    count;
  static float  input_windowed[FFT_SIZE_IN*2+1];

  static float  InputSamplesI[FFT_SIZE_IN*2+1];
  static float  InputSamplesQ[FFT_SIZE_IN*2+1];


  static float  inputI[FFT_SIZE_IN*2+1];
  static float  inputQ[FFT_SIZE_IN*2+1];

  double _Complex output[FFT_SIZE_IN*2+1];

  char          Char;//, curr_character, prev_character;
  int           curr_character, prev_character;
  int           nibble1, nibble2, nibble3;
  static int    curr_nibble, prev_nibble, prev2_nibble;

  double	    mag, max_mag;
  int	        max_index;
  int           low = 292, high= 1328;
  int           low_limit, high_limit; 

 if(channel_offset == 350)
		{low_limit =318+350/2.9296875; high_limit = 467+350/2.9296875;} //about 1250Hz and 1700Hz respectively
 else
		{low_limit =318; high_limit = 467;} //about 900Hz and 1350Hz respectively
//  if(tone_spacing == 3)high_limit = 800;  //if we are using closer tone spacing the bandwidth is smaller and we can shrink the capture range to avoid QRM

  static int    counts;

  static float  Noise, Signal;


  Sending_pic = FALSE;  //Allows acess to send textbox again - this has to be in here as it will not trigger if elsewhere

// AGC parameters (based upon Winrad)------------------------------

  if (agcfast == FALSE)
     agc_decay = .9999; //slow agc
  else
     agc_decay = .9995; //fast agc

  agcthr = 60.e-5;
  agcgain = .05;
  agcgain = pow(agcgain, 2.2) * 2.;

// ----------------------------------------------------------------------------
  // Argument inputBuffer may be NULL during start-up so...

  if (inputBuffer == NULL)
    return 0;

  // Read input buffer

  for (frameCnt = 0; frameCnt < framesPerBuffer; frameCnt++)
    {
    // Get interleaved soundcard samples from input buffer
                             
    leftInput  = *in++;
    rightInput = *in++; // right channel not used but we must pick it anyway


     InputSamplesI[++k] = leftInput;

{ 
//****************************************************************************
//                     -- Image mode demodulator --
//****************************************************************************

if(PicStart == TRUE) demodulate_image(leftInput);

//****************************************************************************
//                     -- End of image mode demodulator --
//****************************************************************************


// ----------------------------------------------------------------------------

  if(SpectrumAveragebutton == TRUE)
           spec_ave = 3;
        else
           spec_ave = 1;
// ----------------------------------------------------------------------------
      
 		

     if(k == FFT_SIZE_IN/16)
       {

         for ( i = 0; i < FFT_SIZE_IN/16; i++) //circular buffer for symbol "sync"
          {  


// AGC section ---------------------------------------------------------------
					if(agcOFF == TRUE)goto skip_agc;
	{
		tmp = fabs(InputSamplesI[i]);

		if(ss < tmp)
		{ ss = (9. * ss + tmp) / 10.;    // slow down attack time
		  pk = tmp;
		  hangcnt = (agcfast == TRUE) ? 1 : 6;
		}

		if(agc != FALSE)
		  InputSamplesI[i] *= 0.29 / max(ss, agcthr);

		else
		  InputSamplesI[i] *= 3.e3 * agcgain;


		if(hangcnt == 0)
		  ss  *= agc_decay;

		pk  *= agc_decay;
	}

	if(hangcnt > 0)  hangcnt--;
					
skip_agc:

// ----------------------------------------------------------------------------
//  Move the samples along 1/16th of a symbol length at a time

            inputI[i]                     = inputI[i +   FFT_SIZE_IN/16];
			inputI[i +   FFT_SIZE_IN/16]  = inputI[i + 2*FFT_SIZE_IN/16];
			inputI[i + 2*FFT_SIZE_IN/16]  = inputI[i + 3*FFT_SIZE_IN/16];
			inputI[i + 3*FFT_SIZE_IN/16]  = inputI[i + 4*FFT_SIZE_IN/16];
            inputI[i + 4*FFT_SIZE_IN/16]  = inputI[i + 5*FFT_SIZE_IN/16];
            inputI[i + 5*FFT_SIZE_IN/16]  = inputI[i + 6*FFT_SIZE_IN/16];
	        inputI[i + 6*FFT_SIZE_IN/16]  = inputI[i + 7*FFT_SIZE_IN/16];
			inputI[i + 7*FFT_SIZE_IN/16]  = inputI[i + 8*FFT_SIZE_IN/16];
            inputI[i + 8*FFT_SIZE_IN/16]  = inputI[i + 9*FFT_SIZE_IN/16];
			inputI[i + 9*FFT_SIZE_IN/16]  = inputI[i + 10*FFT_SIZE_IN/16];
			inputI[i + 10*FFT_SIZE_IN/16] = inputI[i + 11*FFT_SIZE_IN/16];
			inputI[i + 11*FFT_SIZE_IN/16] = inputI[i + 12*FFT_SIZE_IN/16];
            inputI[i + 12*FFT_SIZE_IN/16] = inputI[i + 13*FFT_SIZE_IN/16];
            inputI[i + 13*FFT_SIZE_IN/16] = inputI[i + 14*FFT_SIZE_IN/16];
	        inputI[i + 14*FFT_SIZE_IN/16] = inputI[i + 15*FFT_SIZE_IN/16];
			inputI[i + 15*FFT_SIZE_IN/16] = inputI[i + 16*FFT_SIZE_IN/16];
            inputI[i + 16*FFT_SIZE_IN/16] = inputI[i + 17*FFT_SIZE_IN/16];			
			inputI[i + 17*FFT_SIZE_IN/16] = InputSamplesI[i]*4;


}


        for ( i = 0; i < FFT_SIZE_IN; i++) 
          {          
            g_fltFftBufRe[i] = inputI[i]*(0.42-0.5*cos(6.2832*(i)/FFT_SIZE_IN) + 0.08*cos(2*6.2832*(i)/FFT_SIZE_IN));//Blackman-Something window;
            Speed_Re[i]      = inputI[i]; //no window for use in speed meter
	      }

      //     dspmath_MultiplyBlackmanWindow (g_fltFftBufRe, FFT_SIZE_IN);
     //      dspmath_MultiplyBlackmanWindow (g_fltFftBufIm, FFT_SIZE_IN);
          dspmath_CalcRealFft (FFT_SIZE_IN,    //FFT for decoding and display
                               g_fltFftBufRe,    
                               g_fltFftBufIm) ;

          dspmath_CalcRealFft (FFT_SIZE_IN,   //Unwindowed FFT for speed calculation and display on bar grpah
                                  Speed_Re,    
                                  Speed_Im) ;

		 k=0;
         max = 0.0; 
         peak =0; 

		 maxSpeed = 0.0;
		 peakSpeed = 0.0;
			  

        for (i = 0; i < high; ++i)
        {
            g_PlotPeak[i] = 0;
   
                re = g_fltFftBufRe[i];
		        im = g_fltFftBufIm[i];

                              
          rTmp = spec_ave*SMOOTH_K * (sqrt(re*re+im*im)- g_fltPlotFftV[i]);
          g_fltPlotFftV[i] += rTmp; 
        }

        for (i = 0; i < high; ++i) //do the same for the Speed FFT's
        {
         
                reSpeed = Speed_Re[i];
		        imSpeed = Speed_Im[i];
                              
          rTmpSpeed = spec_ave*SMOOTH_K * (sqrt(reSpeed*reSpeed+imSpeed*imSpeed)- SpeedPlotFft[i]);
          SpeedPlotFft[i] += rTmpSpeed; 
        }

//find the maximum bin
        for (i = low_limit; i < high_limit; ++i)
        {
          val =  g_fltPlotFftV[i]; 
          if(val > max)
            {
             max  = val;
			 peak = i;
            }           
        }
//Save raw data to a file when requested******************************************************************

if (Save_RS_data == TRUE)	//SetWindowText(hwnd,"test");     
	{
      sample_buffer[sample_index++] = peak;
	 if(sample_index>400000)sample_index=0;     //perhaps this should go further down?                                        
    }
/*else
	{
	 // sample_index = 0;
	}
*/
//*********************************************************************************************************


//And the same for Speed routine
        for (i = low_limit; i < high_limit; ++i)
        {
          valSpeed =  SpeedPlotFft[i]; 
          if(valSpeed > maxSpeed)
            {
             maxSpeed  = valSpeed;
			 peakSpeed = i;
            }           
        }


//find signal/noise ratio

  Noise = 0;

  for (i = low; i < high; ++i) 
        {
         Noise += g_fltPlotFftV[i];         
        }
   Signal = (g_fltPlotFftV[peak-1] +g_fltPlotFftV[peak] + g_fltPlotFftV[peak+1]);
   Noise -= Signal;

   Signal_to_Noise = Signal/(Noise)*1.4*1.4;  //normalise to 3000Hz b/w to agree with PATHSIM simulations
   if (Signal_to_Noise < 0.0001)Signal_to_Noise = 0.0001;
   Sig_to_noise = 20*log10(Signal_to_Noise);  //not sure it should be 20log but that seems to agree with PATHSIM simulations


				
 if(FSQCAL == TRUE)
        {
    //     signoise = (signoise*29 + (350-(int)Sig_to_noise*2.7))/30;  //add a little time averaging - this goes to the graphics paint routine
                                                                      //and the if(signoise>squelch_level) below

		if (isnan(sig))sig = 0.0001;// XXX NW8L - guard against uninitialized value if FSQCAL set
                                    // as consequence of settings file processing at start-up.
		Sig_to_noise = 20*log10(sig);
	
        sig = (sig + Signal_to_Noise)*.95;  //Averaging - fast attack/slow decay
 
		Sig_to_noise = 20*log10(sig);
			
		
				signoise = (415 - Sig_to_noise*2.7);  //so Sig_to_noise  = (415 - signoise)/2.7
			

         Sig_to_noise2 = (Sig_to_noise2*19 + (5 + (int)(Sig_to_noise*1.15)))/20;  //This one is for the ? SNR reply 
 	 
        }
  else
		{
         signoise = (signoise*2 + (350-(int)Sig_to_noise*2.7))/3;  //add a little time averaging - this goes to the graphics paint routine
                                                                      //and the if(signoise>squelch_level) below

         Sig_to_noise2 = (Sig_to_noise2*2 + (5 + (int)(Sig_to_noise*1.15)))/3;  //This one is for the SNR ? reply 
		}
     //NB. Must cast the Sig_to_noise as an int otherwise odd characters get appended to the curr_character stream



//mark the peak symbol in yellow
            g_PlotPeak[peak] = 255;
			peak_symbol = g_fltPlotFftV[peak];


//now see if we have several peaks in a row, indicating the presence of a symbol
          peak_val =  peak;     
		  if(peak_val == prev_peak)
				{
				 peak_counter++;
			    }

//And the same for Speed routine
          peak_valSpeed =  peakSpeed;     
		  if(peak_valSpeed == prev_peakSpeed)
				{
				 speed_counter++;
			    }

//Count the number of peak hits for use as a baud rate metric          
          if(prev_peakSpeed != peak_valSpeed)
			{   char peaks[1];
				if(speed_counter < 2)speed_counter = 2;  //reduce some of the extreme jitteriness
				peaks_count = (peaks_count*9 + (float)speed_counter)/10;

		    	speed_counter = 0;
			}


//If we count more than 3 (or 6) peaks call it a symbol and reset counter
          prev_peak = peak;
          prev_peakSpeed = peakSpeed;

          if(peak_counter > peak_hits)  //more than 6 peaks (normally peak_hits = 6) out of a possible 16 indicates a symbol rather than noise
			{				
				symbol = peak;
				peak_counter = 0;  //reset counter ready for next symbol
			}


//Average all symbols to get an idea of the average frequency (to keep track of vfo drift etc)
//This is really a waste of time, as what do you do with the data?? You can see the tones on screen
//and how do you save the average?
       //   char toneaverage[1];
       //   tone_average = 0.999 * tone_average + 0.001 * symbol; 
       //   sprintf(toneaverage,"%d",(int)(tone_average*2.9296875));   
       //   SetWindowText(hwnd,toneaverage);
//Ditch it for now! 
	
//int rem;
//determine the difference between current and previous symbol
      //    nibble = floor((float)(symbol - prev_symbol+1)/4);  //now this works perfectly once I type cast the difference (float)
   //       nibble = floor(0.25+(float)(symbol - prev_symbol)/4); //this does the same thing
	//	  nibble = floor(0.5+(float)(symbol - prev_symbol)/3);

          if(tone_spacing == 4)
			{nibble = floor((float)(symbol - prev_symbol+1)/4);}
		  else
			{ nibble = floor(0.5+(float)(symbol - prev_symbol)/3);}
		


          if(nibble < 0) nibble = nibble + 33; //allow for wrap-around (33 tones for 32 tone differences)
	       nibble = nibble - 1;  //1 is added at the TX end so need to subtract it here

           if(nibble < 0)goto skip;  //-1 is our idle symbol, indicating we already have our symbol
			                         //Wait for next one to arrive


//Varicode decoder
    curr_nibble = nibble;



//single-nibble characters
int text_length;
     if((prev_nibble < 29) & (curr_nibble < 29))  
		{
		   curr_character = wsq_varidecode[prev_nibble];

//We want only characters between 32 and 127, but including a few useful ones above 127
         if((curr_character==163)|(curr_character==215)|(curr_character==177)|(curr_character==247)|(curr_character==176))goto skip_next;//allow these characters
         if((curr_character<8)|(curr_character>127))curr_character = 31*0; //to avoid "bonk" sound (esp. ascii 7)
	     if((curr_character>10)&(curr_character<31))curr_character = 31*0;  //- substitute a non-printing character
         if(curr_character == 9)curr_character = 0;                   //don't forget the 9 in between 8 and 10

skip_next:
   
 

       
//See if signal is above squelch level
    if(signoise > squelch_level) goto skip1; //back-to-front because Windoze has the screen upside down!
			                                 //We need to put the squelch in here so that we can still feed charcaters to the FIFO

	
      //make sure caret stays at end of text
           text_length = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);  
           SendMessage(hCtl, EM_SETSEL, text_length,text_length);   //should we use EM_EXSETSEL to avoid the 64k text limit? Or is it the other way?
//******************************************************************************
//And the same for the monitor text box
           int mon_text_length = SendMessage(hwndMonitor, WM_GETTEXTLENGTH, 0, 0);  
           SendMessage(hwndMonitor, EM_SETSEL, mon_text_length,mon_text_length);

//******************************************************************************


  cf.cbSize      = sizeof(cf);       //Length of structure
  cf.dwMask      = CFM_COLOR;    //Set mask to colors only
  if(Text_colour == TRUE)
		{
         cf.crTextColor = RGB(0,120,0);      //Set the new colour value 
        }
  else
        {
         cf.crTextColor = RGB(0,0,0);      //Set the colour back to black 
        }  
  SendMessage(hCtl, EM_SETCHARFORMAT, SCF_SELECTION,(LPARAM) &cf);

  if(FSQCAL==FALSE)   SendMessage ( hCtl, EM_REPLACESEL, 0, (LPARAM)&curr_character);  
           SendMessage ( hCtl, EM_SCROLLCARET, 0, 0 ); 
	       SendMessage ( hwnd, WM_MOUSEMOVE, 0, 0);                 //counteract it by forcing a mouse move 

//******************************************************************************
//And the same for the monitor text box 
if(curr_character == 8) goto skip1;          
		   SendMessage ( hwndMonitor, EM_REPLACESEL, 0, (LPARAM)&curr_character);  
           SendMessage ( hwndMonitor, EM_SCROLLCARET, 0, 0 ); 
	       SendMessage ( hwndTab, WM_MOUSEMOVE, 0, 0);
//******************************************************************************      
        }

skip1:


//double-nibble characters


	 if((prev_nibble < 29) & (curr_nibble > 28)) 
 		{
		   curr_character = wsq_varidecode[prev_nibble * 32  + curr_nibble];

         if((curr_character==163)|(curr_character==215)|(curr_character==177)|(curr_character==247)|(curr_character==176) )goto skip_next2;//allow these characters
         if((curr_character<8)|(curr_character>127))curr_character = 31*0; //to avoid "bonk" sound (esp. ascii 7)
	     if((curr_character>10)&(curr_character<31))curr_character = 31*0;  //- substitute a non-printing character
         if(curr_character == 9)curr_character = 0;                   //don't forget the 9 in between 8 and 10
skip_next2:



//See if signal is above squelch level
    if(signoise > squelch_level) goto skip2; //back-to-front because Windoze has the screen upside down!
			                                 //We need to put the squelch in here so that we can still feed charcaters to the FIFO

           			
           text_length = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0); 
           SendMessage(hCtl, EM_SETSEL, text_length, text_length);
//******************************************************************************
//And the same yet again for the monitor text box
           int mon_text_length = SendMessage(hwndMonitor, WM_GETTEXTLENGTH, 0, 0);  
           SendMessage(hwndMonitor, EM_SETSEL, mon_text_length,mon_text_length);

//******************************************************************************


                                                   //colour it again here, just in case
  cf.cbSize      = sizeof(cf);       //Length of structure
  cf.dwMask      = CFM_COLOR;    //Set mask to colors only
  if(Text_colour == TRUE)
		{
         cf.crTextColor = RGB(0,120,0);      //Set the new colour value 
        }
  else
        {
         cf.crTextColor = RGB(0,0,0);      //Set the colour back to black 
        } 
  SendMessage(hCtl, EM_SETCHARFORMAT, SCF_SELECTION,(LPARAM) &cf);

  if(FSQCAL==FALSE)    SendMessage ( hCtl, EM_REPLACESEL, 0, (LPARAM)&curr_character);     
           SendMessage ( hCtl, EM_SCROLLCARET, 0, 0 );                                         
		   SendMessage ( hwnd, WM_MOUSEMOVE, 0, 0); 

//******************************************************************************
//And the same yet again and again for the monitor text box 
if(curr_character == 8) goto skip2;            
		   SendMessage ( hwndMonitor, EM_REPLACESEL, 0, (LPARAM)&curr_character);  
           SendMessage ( hwndMonitor, EM_SCROLLCARET, 0, 0 ); 
	       SendMessage ( hwndTab, WM_MOUSEMOVE, 0, 0);
//******************************************************************************      
          
        }

skip2: 
     prev_nibble = curr_nibble;


/****************************************************************************************
/****************************************************************************************
		==============SELCAL stuff starts here====================
*****************************************************************************************
****************************************************************************************/

/***************************************************
  FIFO to look for callsigns and SELCAL metacommands
****************************************************/
//if(curr_character >248) goto skip;  //We get an unwanted character "0 with line through it" with the signoise =  line above
//if(curr_character == 0)goto skip;   /*Nulls seem to be appended to the double-nibble characters 
			                        //- get rid of them as they mess up the c string operations*/
//In WinXP, a character above ascii 248 causes trouble with double-nibble characters (seems to be OK in Win7)
         if((curr_character==163)|(curr_character==215)|(curr_character==177)|(curr_character==247)|(curr_character==176) )goto skip_next3;//allow these characters
         if((curr_character<8)|(curr_character>127))curr_character = 0; //to avoid "bonk" sound (esp. ascii 7)
	     if((curr_character>10)&(curr_character<31))curr_character = 0;  //- substitute a non-printing character
         if(curr_character == 9)curr_character = 0;                   //don't forget the 9 in between 8 and 10
skip_next3:

if(curr_character == 0)goto skip; //take care of the nulls


			
 int i, j, k, l, m;

            input_text[0] = input_text[1];
            input_text[1] = input_text[2];
            input_text[2] = input_text[3];
            input_text[3] = input_text[4];
            input_text[4] = input_text[5];
            input_text[5] = input_text[6];
            input_text[6] = input_text[7];
            input_text[7] = input_text[8];
            input_text[8] = input_text[9];
            input_text[9] = input_text[10];
            input_text[10] = input_text[11];
            input_text[11] = input_text[12];
            input_text[12] = input_text[13];
            input_text[13] = input_text[14];
            input_text[14] = input_text[15];
            input_text[15] = input_text[16];
            input_text[16] = input_text[17];
            input_text[17] = input_text[18];
            input_text[18] = input_text[19];
            input_text[19] = input_text[20];
            input_text[20] = input_text[21];
			input_text[21] = input_text[22];
            input_text[22] = curr_character;    






// SetWindowText(hwnd, &input_text[0]);

 char  text[20];

   // MUST be a STATIC UNSIGNED char!!!
                                             //Also must be bigger than the longest call possible otherwise will get
 //static unsigned char call_found[20] ;       //partial calls being seen as already existing eg. ZL1BPU will be a subset of ZL1BPU/P
                                             //Must also be static so that we can use it further below ??
                                              //(Now a global variable as we need it for the Alert thread)
 static unsigned char search_call[20];
			
			 int found;
 int call_start;            





if(FSQCAL_CREATE==FALSE)goto skip;


//SNR for reporting to heard log and the ? reply
             SNR = Sig_to_noise2 - 9;                 //the -9 makes it agree with PATHSIM simulations
             sprintf(snr, " snr=%d%s",(int)SNR,"dB"); //save S/N for use later, when squelch has closed and signal has gone
     

/*********************************************************************
           Wait until a ':' moves into position [20]
**********************************************************************/
       if((input_text[20]==':')&&(CALL_FOUND == FALSE))        //If we find a trigger then work backwards until we find a CRLF or else get to the beginning of the FIFO buffer			                                  
           {                                                   //Note that it is ':' which is an ascii value, and not ":", which is a string character
                                                               // the CALL_FOUND flag ensures we don't go looking for any more colons omnce we have found the correct call
              for (m=0;m<21;m++)call_found[m]='\0';  //MUST fill buffer with nulls to avoid unpredictable behaviour
              { 
               for(i=20;i>-1;i--)                          //Start searching backwards from the ':'
					{
                     if((input_text[i]=='\n')|(i==0))      //If we don't find a LF then look for metacommands regardless
                           {                               //just in case the callsign is valid anyway and the LF was lost
                            for(found=i;found<20;found++)
	                            {						
                                 call_found[found-i] = input_text[found];   //The [found-i] is the zero index for call_found[0]
						        }                                           //The input_text is mapped to a working buffer, call_found[] 

                            for(j=0;j<20;j++)      //Now look for any characters other than upper case or numbers;if found, don't save the callsign as a valid ID.
	                            {	
					             if((call_found[j]> 0)&&(call_found[j]<8))goto skip;     //We also need character 0 (ie NULL, or is it NUL?) as this is appended by Mr. C
                                 if((call_found[j]>10)&&(call_found[j]<47))goto skip;     //if any less than the numbers  (seems to need && rather than &??)             
							                                                              //We need to retain the LF (=10) for quick closure of FSQCAL?
							                                                              //make sure we include ascii 47 "/" as that is commonly found in a callsign)
                                 if((call_found[j]>57)&&(call_found[j]<65))goto skip;     //if any between the numbers and upper case							    
                                 if((call_found[j]>90)&&(call_found[j]<95))goto skip;     //allow for underscore as well"_", but not [, \, ], and ^
                         //        if (call_found[j]>95)                     goto skip;     //if any lower case 
							     if (call_found[j]>122)                    goto skip;     //allow lower case 	
						        }
		

				   //Check the CRC and see if there is a match 
                                 unsigned char crc8;
                                 unsigned char chr;
					             crc8='\0';
                                 int i2;
                                        
                                 for(i2=1;i2<strlen(call_found);i2++)  //NB. call_found[] is 1-based rather than zero-based
						             {
                                      chr  =  call_found[i2];
                                      crc8 =  crc8_table[(crc8) ^ chr];
                                      crc8 &= 0xFF;
                                     }
							      crc_callfound = crc8;           //save for use in timer in reply routines later on
                                  unsigned char CheckCRC[3];
		                          sprintf(CheckCRC,"%02x",crc8);   //convert the character into two equivalent hex values
		                                        
                                  unsigned char check[3] ={input_text[21],input_text[22],'\0'}; //Don't forget to add the null at the end
                                 
                   //Add call to the list if it is not already there and the CRC matches
							 
                                  if(strcmp(check,CheckCRC)==0)
							         {
								      CALL_FOUND = TRUE;          //Valid call detected - turn on the "trigger search" engine below and stop looking for more colons for the rest of the message
                                      if(FSQCAL==FALSE)goto no_keep;
                                      SendMessage(g_hwndFSQCALbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSELCAL_GREEN); //make FSQCAL button flash green to indicate FSQCAL is open 	



                  // Add station to the "heard" log (.txt file) and timestamp
                                 SYSTEMTIME time_stamp;
                                 char time[256];
                                 GetLocalTime(&time_stamp);            
                              
                                 heardlog= fopen(fullHeardLogpath, "a");    //use full path to ensure that it does not end up in some other current directory
                            //     heardlog= fopen("Heardlog.txt", "a");    //open the heard log only when needed
                                 sprintf(time, ", %02d/%02d/%02d, %02d:%02d:%02d, %s,%d,%s", time_stamp.wDay, time_stamp.wMonth, time_stamp.wYear,time_stamp.wHour, time_stamp.wMinute, time_stamp.wSecond,"snr=",(int)SNR,"dB" );								
								 fprintf(heardlog, "%s%s", call_found,time);
                                 fclose(heardlog);

                  //Remove any CRLF's (they triggered squelch closure in the old scheme and they cause trouble with a CRLF in front of the reply callsign)
                                        remove_char_from_string(0xA, call_found);  //CR                         
                                        remove_char_from_string(0xD, call_found);  //LF 


                  // Now search through the "heard" list, and add call to list if it is not already there

                                      for(k=0;k<1000;k++)                                               //Allow for 1000 calls?
					         	         { 
						                  SendMessage(hwndList, LB_GETTEXT, (WPARAM)k , (LPARAM)text); //Iterate through the list and compare the incoming call with the list entries
							              if(strcmp(text,call_found)==0)goto no_keep;			       //If = 0 this means we have a match, therefore no need to search further        
                                         }                                                             //And exit otherwise we will add up to 1000 entries to the list
                  //Otherwise add to listbox
  
								      SendMessage(hwndList, LB_ADDSTRING, 0, (LPARAM)call_found);
					             	  int items;
						              items = SendMessage (hwndList, LB_GETCOUNT , 0, 0);
						              if(items >= 18)SendMessage (hwndList, LB_DELETESTRING, 1, 0);    //Make the oldest call "expire" to avoid need for a fat scroll bar!                           
                                     }                                                                 //Note "1" is the second call - leave "allcall" in place               
       
                                goto no_keep;
					       }
			     	}            
              }                     
           }
	
 no_keep:

//*************************************************************************************                     
//       Save characters to the message buffer as they come in one at a time
//*************************************************************************************

 if ((signoise<squelch_level)&&(CALL_FOUND == TRUE)||(MANUAL_SAVE_FILE == TRUE)) 
 // if ((signoise<squelch_level)&&(CALL_FOUND == TRUE)||(MANUAL_SAVE_FILE == TRUE))   //remember we are using the graphics "S/N" and it is upside down (Windoze convention!)
			{
             char savechar[0] = {'\0','\0'};           //MUST fill with nulls
			 savechar[0] = curr_character;
             strcat(Message_buffer,savechar);          //Surely there has to be a better way to add the character to the buffer!
             Save_RS_data = TRUE;
            }


//*************************************************************************************
//      Search through the message for own call, CQCQCQ, ALLCALL, and message triggers
//*************************************************************************************

int counter;                   //Murray's concept for a reliable Costas symbol to close squelch, less prone to early closure
if(curr_character == 32) counter++;
if(curr_character != 32) counter = 0;
if((curr_character == 32)&&(counter = 2)) close_squelch = FALSE;
if((curr_character == 8)&&(counter = 2)) {close_squelch = TRUE; counter = 0;}



//========================================================================================
//======   Collect the raw samples if the "save" button has been switched on   ===========
//========================================================================================

if(((signoise>squelch_level)||(close_squelch == TRUE))&&(MANUAL_SAVE_FILE == TRUE))
/*int flag1 = 0;
int flag2 = 0;
int go = 0; 
//if((close_squelch == TRUE)&&(MANUAL_SAVE_FILE == TRUE))flag1 = 1;
					
if((signoise>squelch_level)&&(MANUAL_SAVE_FILE == TRUE))flag2 = 1;

if((flag1 == 1)||(flag2 == 1))go = 1;
if((flag1 == 1)&&(flag2 == 1))go = 1;

if (go == 1)			
*/			{
				
  //Save raw data to file if SAVE button is pressed (ie. a manual save if header is wrecked)

        sprintf(path_plus_filename,"%s\\%s",full_incoming_path,"emergency.enc.RS"); //assume filename is a mess - use a dummy filename and add the path to "Shared" folder
  
    	FILE *RSdata0;
		int nx0=0;
		char str0[400000] = {'\0'};
 		sprintf(str0,"%s","");                           //make sure string does not have junk in it
		char RS_data_path0[256];
    	sprintf(RS_data_path0, "%s",path_plus_filename); 

//char num0[20];
//sprintf(num0,"%d",sample_index);
//SetWindowText(hwnd,num0);

 //Open a file for appending incoming raw samples
    	RSdata0 = fopen(RS_data_path0, "w"); 
    	char s0[1];
		for (nx0=0;nx0<sample_index;nx0++)    //save only those samples collected in last session; ignore the rest which might be junk, although it shouldn't
    	 {
		  sprintf(s0,"%d,",sample_buffer[nx0]);
	 	  strcat(str0,s0);
		 }											
		  fprintf(RSdata0, str0);
    	  fclose(RSdata0);
	

     Save_RS_data = FALSE;
	 for (sample_index=0;sample_index<400000;sample_index++)sample_buffer[sample_index] = 0 ;
     sample_index = 0; 

	 PostMessage(g_hwndSAVEbutton,WM_LBUTTONDOWN,0,0);	
	 for (nx0=0;nx0<32000;nx0++)Message_buffer[nx0]='\0';      //Flush the message buffer with nulls as otherwise the next 				
	    	}												   //file will not trigger due to previous junk in the buffer.	
															   //This will prevent the text file from being received
															   //So it is EITHER the text file OR the raw file, but not both	
															

//========================================================================================
//== If the originating call is correct search through the Message Buffer for text data ==
//========================================================================================

 if((signoise>squelch_level)&&(CALL_FOUND == TRUE)||(close_squelch == TRUE)) //if signal falls below squelch level 

			{ Save_RS_data = FALSE;
     		  sample_total = sample_index;  //how many samples have we gathered?			
			  close_squelch = FALSE;  //reset squelch closer
			  int n=0;
			
//SetWindowText(hwnd,Message_buffer);


//Colour FSQCAL receive text blue
              cf.cbSize      = sizeof(cf);       //Length of structure
              cf.dwMask      = CFM_COLOR;        //Set mask to colors only
              if(Text_colour == TRUE)
		        {
                 cf.crTextColor = RGB(0,0,255);      //Set the new colour value to distinguish it from non-FSQCAL operation
                }
             else
               {
                cf.crTextColor = RGB(0,0,0);      //or set the colour back to black 
               } 
             SendMessage(hCtl, EM_SETCHARFORMAT, SCF_SELECTION,(LPARAM) &cf);

   
//********************************************************************************************************************************************               
//Search through the whole message buffer - don't use a "do" loop!

   static int start1, start;

 //Look for FIRST occurrence of callsign (used only in callsign# and allcall# for file transfer)
			 for (n=1;n<32000;n++)  
			   {	                                               
                if((strstr(&Message_buffer[n],callsign)!=0)|
                   (strstr(&Message_buffer[n],"cqcqcq")!=0)|
				   (strstr(&Message_buffer[n],"allcall")!=0))
				    {                  
                        start1 = n;
						
						goto found_first;
                    }
					if(Message_buffer[n] == 8)Message_buffer[n] =0;  //re-assign BS to a NULL so it doesn't show up a a box at the end
				}                                                     //I hope this doesn't cause trouble with files later on! 
				found_first:                                         

  
 //Look for the other occurrences of callsign 

			 for (n=0;n<32000;n++)  
			   {	                                               
                if((strstr(&Message_buffer[n],callsign)!=0)|
                   (strstr(&Message_buffer[n],"cqcqcq")!=0)|
				   (strstr(&Message_buffer[n],"allcall")!=0))
				    {                  
                        start = n;
                    }
					if(Message_buffer[n] == 8)Message_buffer[n] =0;  //re-assign BS to a NULL so it doesn't show up a a box at the end
				}                                                     //I hope this doesn't cause trouble with files later on! 
			                                         


//********************************************************************************************************************************************               
//Start searching for triggers from the "start" point ie. forget everything before own_call
 
         if((strstr(&Message_buffer[start],callsign)!=0)|
                   (strstr(&Message_buffer[start],"cqcqcq")!=0)|
				   (strstr(&Message_buffer[start],"allcall")!=0))
				      { 
                 
/* DON'T PUT THIS HERE - IT WILL ALSO PREVENT PRINTING!
//First check to see if there is any text in the send box. If there is, inhibit any replies to prevent premature transmission of intended text
                      int send_len;
					  send_len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
					  if(send_len!=0)goto skip0;

        
*/						
//"Remote access" command - switch FSQCAL from "sleep" to "active" and light up SELCAL button blue						
						if((Message_buffer[start+strlen(callsign)]=='*'))//&&(FSQCAL==FALSE))//(fsqcal_active == FALSE))
					 				{ 
                                      FSQCAL = FALSE;
                                      SendMessage(g_hwndFSQCALbutton,WM_LBUTTONDOWN,0,0); //MUST use SendMessage in this case
                            
                                      FSQCAL = TRUE;

                           //Send confirmation that FSQCAL is active back to originating station
					                 KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
	                
					                 int len;
/*void displayText(HWND h, unsigned char *txtBuf)
{
    int len;
    len = SendMessage(h, WM_GETTEXTLENGTH, 0, 0);   
    SendMessage(h, EM_SETSEL, len, len);  // XXX NW8L must set selection this way
    SendMessage(h, EM_REPLACESEL, 0, (LPARAM) txtBuf);
}
*/							         
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" ");  //need a space so that the receiver can recognise own call                                     
								     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)"Active");

                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisaion and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                   
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);					               						
                                          SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM)call_found); //append call_found to the beginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);								   
                                     goto skip0;// break;
                                    }

                         if(FSQCAL == FALSE)goto skip0;    
                  //     if(fsqcal_active == FALSE) goto skip;  //only respond to the "*" command

//********************************************************************************************************************************************
// " H(eard)" command to print Heard List reply messages to main receive screen, otherwise the "space" command will only print calls after own call!
                         if((Message_buffer[start1+strlen(callsign)+1]=='H')&&(strncmp(&Message_buffer[start1],callsign,strlen(callsign))==0))
                                                                                     
				                    {                              
                                         { 
					                      int len;
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the beginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start1+strlen(callsign)+1]); //NB. uses "start1"
				                         }
							         goto skip_next_one;
						             
		                            }
//********************************************************************************************************************************************
// "space" command to print repeat message replies to receive screen (no need to consider "ALLCALL", as that is taken care of separately above)

                         if((Message_buffer[start1+strlen(callsign)]==' ')&&(strncmp(&Message_buffer[start1],callsign,strlen(callsign))==0))
                                                                                     
				                    {                              
                                         { 
					                      int len;
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the beginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]); //NB. uses "start"
	                   
							
					//	char num[2];
					//	sprintf(num,"%d",start);
					//	SetWindowText(hwnd,num);
				                         }
							         goto skip0;
						             
		                            }

skip_next_one:
//********************************************************************************************************************************************
//"ALERT" command - reply upon pressing OK button in a message window

                         if(Message_buffer[start+strlen(callsign)]=='|') 
				                    { 
                                
					                      int len;
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the beginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                                    
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);

          //Transfer the return message to a global string 
                                       int i; 
                                       for(i=0;i<1024;i++) message[i]='\0'; //initialise with nulls
                                       sprintf(message,"%s", &Message_buffer[start+strlen(callsign)+1]);
 
          //Play a 1 1/2 second 800Hz "beep" through the loudspeaker, if available
		                               Beep(800,1500);

          //This needs to go in a separate thread to avoid stalling the program - Thread(void) - see function in code above
                                    _beginthread (Thread, 0, 0) ;


                                     goto skip0;
                                    }                               




//********************************************************************************************************************************************
//General "ALLCALL" command - print only the message to screen
                      //   if(Message_buffer[start+strlen("allcall")]==' ')  
                     if(strstr(&Message_buffer[start],"allcall ")!=0) 
                                    { 
                          
                                         {
					                      int len;
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the beginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);                                        		 					                 
                                          SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start+7]);
				                         }
                                     goto skip0;
		                            }


//********************************************************************************************************************************************                   
//CQCQCQ message - print the message and the CQCQCQ, so that it is obvious as a CQ   
             	    
                          if(strstr(&Message_buffer[start],"cqcqcq ")!=0)  
                                    {   if(cqcqcq_print_on == FALSE)goto skip0;      //turn off printing if required                   
                                         { 					 			
					                      int len;
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the beginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                           
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);										         
                               
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start]);								         
				                         }
                                         goto skip0;
		                            } 

//********************************************************************************************************************************************
//"IMAGE" commands - starts demodulating incoming picture, or starts the webcam remotely
// This is all very clumsy, but does work
//********************************************************************************************************************************************
   if((Message_buffer[start+strlen(callsign)]=='%')|(Message_buffer[start+strlen("allcall")]=='%'))
				                    {

                               //Start the picture receiver
                                       if((Message_buffer[start+strlen(callsign)+2]  == 'S')
								         |(Message_buffer[start+strlen("allcall")+2] == 'S')) 
								                        {
								                         SMALL_PIC = TRUE;
                                                         LARGE_PIC = FALSE;
								                         VERYLARGE_PIC = FALSE;
								                         FAX = FALSE;

								                         SendMessage(hwnd, WM_COMMAND,IDC_RECEIVE_PIC_BUTTON,0);
                                                         goto skip0;  
							                            }
                                       else   
                                       if((Message_buffer[start+strlen(callsign)+2]  == 'L')
								         |(Message_buffer[start+strlen("allcall")+2] == 'L')) 
								                        {
								                         SMALL_PIC = FALSE;
                                                         LARGE_PIC = TRUE;
								                         VERYLARGE_PIC = FALSE;
								                         FAX = FALSE;
								                         SendMessage(hwnd, WM_COMMAND,IDC_RECEIVE_PIC_BUTTON,0);
								                         goto skip0;
							                            }
                                       else   
                                       if((Message_buffer[start+strlen(callsign)+2]  == 'F')
								         |(Message_buffer[start+strlen("allcall")+2] == 'F')) 
								                        {
								                         SMALL_PIC = FALSE;
                                                         LARGE_PIC = FALSE;
								                         VERYLARGE_PIC = FALSE;
								                         FAX = TRUE;
								                         SendMessage(hwnd, WM_COMMAND,IDC_RECEIVE_PIC_BUTTON,0);
								                         goto skip0;
							                            }
                                       else   
                                       if((Message_buffer[start+strlen(callsign)+2]  == 'V')
								         |(Message_buffer[start+strlen("allcall")+2] == 'V')) 
								                        {
								                         SMALL_PIC = FALSE;
                                                         LARGE_PIC = FALSE;
								                         VERYLARGE_PIC = TRUE;
								                         FAX = FALSE;
								                         SendMessage(hwnd, WM_COMMAND,IDC_RECEIVE_PIC_BUTTON,0);
								                         goto skip0;
							                            }

   
                               //Start the webcam 
							  if(Webcam != TRUE)goto no_webcam;  //Check if webcam send routine is turned off

						             if(Message_buffer[start+strlen(callsign)+2]  == 'w')
								     
								       
							
                                                        {
								                         SMALL_PIC = TRUE;
                                                         LARGE_PIC = FALSE;
								                         VERYLARGE_PIC = FALSE;
								                         FAX = FALSE;

								                         Remote_webcam = TRUE;
								                         SendMessage(hwnd, WM_COMMAND,IDC_WEBCAM_BUTTON,0);

                                                         int len;
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //Send the message to the TX box ready to transmit
                                                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
							                             SendMessage(hCtl_TX, EM_SETSEL, len, len);
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)"%");      //Append the image trigger to let other station know to start receving a picture
    
                                                         int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                                                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                                     SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
                                                         goto skip0;
                                                        }

						             if(Message_buffer[start+strlen(callsign)+2]  == 'W')
								      
								
                                                        {
								                         SMALL_PIC = FALSE;
                                                         LARGE_PIC = TRUE;
								                         VERYLARGE_PIC = FALSE;
								                         FAX = FALSE;

								                         Remote_webcam = TRUE;
								                         SendMessage(hwnd, WM_COMMAND,IDC_WEBCAM_BUTTON,0);

                                                         int len;
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //Send the message to the TX box ready to transmit
                                                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
							                             SendMessage(hCtl_TX, EM_SETSEL, len, len);
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)"%");      //Append the image trigger to let other station know to start receving a picture
    
                                                         int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                                                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                                     SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
                                                         goto skip0;
							                            }

						             if(Message_buffer[start+strlen(callsign)+2]  == 'f')
								      
								
                                                        {
								                         SMALL_PIC = FALSE;
                                                         LARGE_PIC = FALSE;
								                         VERYLARGE_PIC = FALSE;
								                         FAX = TRUE;

								                         Remote_webcam = TRUE;
								                         SendMessage(hwnd, WM_COMMAND,IDC_WEBCAM_BUTTON,0);

                                                         int len;
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //Send the message to the TX box ready to transmit
                                                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
							                             SendMessage(hCtl_TX, EM_SETSEL, len, len);
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)"%");      //Append the image trigger to let other station know to start receving a picture
    
                                                         int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                                                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                                     SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
                                                         goto skip0;
							                            }

						             if(Message_buffer[start+strlen(callsign)+2]  == 'v')
								     
								
                                                        {
								                         SMALL_PIC = FALSE;
                                                         LARGE_PIC = FALSE;
								                         VERYLARGE_PIC = TRUE;
								                         FAX = TRUE;

								                         Remote_webcam = TRUE;
								                         SendMessage(hwnd, WM_COMMAND,IDC_WEBCAM_BUTTON,0);

                                                         int len;
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //Send the message to the TX box ready to transmit
                                                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
							                             SendMessage(hCtl_TX, EM_SETSEL, len, len);
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)"%");      //Append the image trigger to let other station know to start receving a picture
    
                                                         int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                                                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                                     SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
                                                         goto skip0;
							                            }
                                      goto skip0;
                               no_webcam:    //send reply "not available"
                               ;             //<== need ; to avoid compiler error 
                                                         int len;
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //Send the message to the TX box ready to transmit
                                                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
							                             SendMessage(hCtl_TX, EM_SETSEL, len, len);
                                                         SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)" Webcam not available");      //Append the image trigger to let other station know to start receving a picture
    
                                                   //      int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                             srand((int)clock());
    													 int starts = 500 + rand() % 3000;                                                              // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                                     SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
                                                         goto skip0;
						          			
                              
                                     goto skip0;                                                                  
                                    }

//********************************************************************************************************************************************
// End of image-specific command stuff
//********************************************************************************************************************************************

					
//********************************************************************************************************************************************     					
//Now check to see if there is any text in the send box. If there is, inhibit any replies to prevent premature transmission of intended text
//This only applies to commands that have a reply component, as all below
                      int send_len;
					  send_len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
					  if(send_len!=0)goto skip0;




//********************************************************************************************************************************************
//Directed call "Save message to file" command
 
                        if((Message_buffer[start1+strlen(callsign)]=='#')&&(strncmp(&Message_buffer[start1],callsign,strlen(callsign))==0)) 
							
				                    {   
						               int crlf;
	                                   crlf=10;

                                     if(Message_buffer[start1+strlen(callsign)+1] == '[')  //If we find the opening bracket, search for the closing one...
                                      {
                                        int i;
						                for(i = 0;i < 256;i++)  //limit the search for characters in the file name to 256 characters (still quite a lot!)
							               {
							                if(Message_buffer[start1+strlen(callsign)+1+i] == ']')    //Found it!
								                { 
									              static int filename_len;
                                                  filename_len = i+1;
									              unsigned char filenumber[256];// = {'\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0'};
							                      int n;
                                                  for(n=0;n<256;n++) filenumber[n]='\0';  //flush the buffer with nulls

							                      strncpy(filenumber,&Message_buffer[start1+strlen(callsign)+1],filename_len);
                                                  sprintf(filename,"%s",filenumber);
                                                 
                                                  
                                                            
                                                  char temp_filename[256];//strip off the [ and ] from the incoming filename - No! This screws it up elsewhere.
                                                  for(n=0;n<256;n++) temp_filename[n]='\0';  //flush the buffer with nulls
										          for(n=0;n<256;n++) new_filename[n]='\0';   //flush the buffer with nulls
                                                  strcpy(temp_filename,&filename[1]);
                                                  strncpy(new_filename,temp_filename,strlen(temp_filename)-1);

										//Test for illegal characters which indicate a different file path
										          char *p = strchr(new_filename, '\\' );
										          char *q = strchr(new_filename, '/' );
                                                  if ((p != 0)|(q != 0))
										          {
											       goto send_error_message;
										          }
									              else
										          {
				 						 //Test for presence of "-" indicating that it is a telemetry frame. Add timestamp and SNR if it is.
                                                  char *r = strchr(new_filename, '-' );
												  char TSandSNR[256];
                                                  if ((r != 0) & (AddTimestampandSNR == TRUE))
                                                  	{
                                                   //code for timestamp and snr;
                               						 	SYSTEMTIME Time_stamp;
                                					 	GetLocalTime(&Time_stamp);
 														sprintf(TSandSNR, "%02d:%02d%#3d", Time_stamp.wHour, Time_stamp.wMinute, (int)SNR);
													}
													else
													{
														sprintf(TSandSNR, "\0");
													}

										//All good; save to file! 
                                 			       sprintf(path_plus_filename,"%s\\%s",full_incoming_path,new_filename); //add the path to "Shared" folder
                                                   savefile = fopen(path_plus_filename, "a");     //Open a file for appending incoming text 

                                                   char file_crlf[32000] = {'\0'};
												   sprintf(file_crlf,"%s","");
							                       sprintf(file_crlf,"%s%s\n",TSandSNR, &Message_buffer[start1+strlen(callsign)+1+filename_len]);//adds a new line (\n)
							                   //   sprintf(file_crlf,"%s", &Message_buffer[start1+strlen(callsign)+1+filename_len]);//adds a new line (\n)
							                                        
					                               fprintf(savefile, "%s", file_crlf);
                                                   fclose(savefile);
                                                    
   //Save raw data to file if required.... 
  
    char *suffix = strstr(path_plus_filename, ".enc");  //Look for a ".enc" suffix
    if (suffix != 0)	                                //if found, then transfer raw samples to file																							
    {
    	FILE *RSdata;
		int nx=0;
		char str[400000] = {'\0'};
 		sprintf(str,"%s","");                           //make sure string does not have junk in it
		//str[0] = 0;
		//strcpy(str,"");
		char RS_data_path[256];
    	sprintf(RS_data_path, "%s%s",path_plus_filename, ".RS");  //add .RS suffix to file so it is recognised by the decoder helper program

//char num[20];
//sprintf(num,"%d",sample_index);
//SetWindowText(hwnd,num);

 //Open a file for appending incoming text
    	RSdata = fopen(RS_data_path, "w"); 
    	char s[1];
		for (nx=0;nx<sample_index;nx++)    //save only those samples collected in last session; ignore the rest which might be junk, although it shouldn't
    	 {
		  sprintf(s,"%d,",sample_buffer[nx]);
	 	  strcat(str,s);
		 }											
		  fprintf(RSdata, str);
    	  fclose(RSdata);
	}

     Save_RS_data = FALSE;   //reset just in case
	 for (sample_index=0;sample_index<400000;sample_index++)sample_buffer[sample_index] = 0 ;
     sample_index = 0; 
	// SAVE_FILE = FALSE; 
	// SendMessage(g_hwndSAVEbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSAVE_OFF);


                                                   MSGRX = TRUE;

                                       //Test again for presence of "-" indicating that it is a telemetry frame. Don't send an "ack" if it is.
										       //   char *r = strchr(new_filename, '-' );
										          if (r != 0)
										          {
											       goto no_ack;
										          }
													else
													{
										             goto quit_finding_more_brackets;
													}
											      }
                                                }								       
                                           }
quit_finding_more_brackets:
                            //Send confirmation of receipt of file back to originating station
					                 KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
	                
					                 int len;
			                    
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" ack");//need a space so that the receiver can recognise own call                                     
								    
										//Start a timer and then TX after squelch has closed 								       
										srand((int)clock());
										int starts = 500 + rand() % 3000;
										SetTimer(hwnd, 1, starts, NULL);     
                                  //   int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					              //   SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  


no_ack:					                  len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the beginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start1+strlen(callsign)+1]);

							        //      SendMessage(hwndRXfile, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start1+strlen(callsign)+1]);//echo received text to RXfile tab                               
                                    //      len = SendMessage(hwndRXfile, WM_GETTEXTLENGTH, 0, 0);
						            //      SendMessage(hwndRXfile, EM_REPLACESEL, len, (LPARAM)&crlf);

		                             PostMessage(g_hwndMSGRXbutton,WM_LBUTTONDOWN,0,0);         //Auto-press "MSG_RX" button to light it up red
			     	                                                                            //to let user know that incoming message has been saved
									//Update the accessible file list
										ListShortDirectoryContents(full_incoming_path, FilesShortindexpath);
										ListLongDirectoryContents(full_incoming_path, FilesLongindexpath);
										ListShortDirectoryContents(full_image_path, Imageindexpath);
				
                                      }
							          goto skip0;



send_error_message:                   //Send error message back to originating station
					                    KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                    SetFocus(hCtl_TX);
	                
                                        SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                        int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                        SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" Illegal filename");//need a space so that the receiver can recognise own call                                     

										//Start a timer and then TX after squelch has closed 								       
										srand((int)clock());
										int starts = 500 + rand() % 3000;
										SetTimer(hwnd, 1, starts, NULL);     
                                     //   int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							         //   SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
						            goto skip0;
								
                      }                                    

//********************************************************************************************************************************************
//KA4CDN mod Directed call "Read message from file" command
 
                        if((Message_buffer[start1 + strlen(callsign)] == '+') && (strncmp(&Message_buffer[start1], callsign, strlen(callsign)) == 0))
                        {
                          directCmdReadFile( &Message_buffer[start1+strlen(callsign)+1], call_found );
                          goto skip0;
                        }

//********************************************************************************************************************************************
//KA4CDN mod Directed call "delete file" command
 
                   //     if((Message_buffer[start1 + strlen(callsign)] == '-') && (strncmp(&Message_buffer[start1], callsign, strlen(callsign)) == 0))
                   //     {
                   //       directCmdDeleteFile( &Message_buffer[start1+strlen(callsign)+1], call_found );
                   //       goto skip0;
                   //     }
//********************************************************************************************************************************************               
//"Increase baud rate" command - reply with confirmation if changed, or OK if already there

                         if(Message_buffer[start+strlen(callsign)]=='>') 
				                  {
                                    { 
					                 KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
				                     unsigned char response[3] = "";

                                     if(symbol_length == 1) sprintf(response,"%s"," 6 baud");

                                     if(symbol_length == 1.5)
                                           {
                                            symbol_length = 1;                                    
								            sprintf(response,"%s"," 6 baud");
								            CheckMenuItem(menu,IDM_6_BAUD,MF_CHECKED);
				                            CheckMenuItem(menu,IDM_45_BAUD,MF_UNCHECKED);
                                            CheckMenuItem(menu,IDM_3_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_2_BAUD,MF_UNCHECKED);
								           }
                                     if(symbol_length == 2)
                                           {
                                            symbol_length = 1.5;                                    
								            sprintf(response,"%s"," 4.5 baud");
								            CheckMenuItem(menu,IDM_6_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_45_BAUD,MF_CHECKED);
                                            CheckMenuItem(menu,IDM_3_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_2_BAUD,MF_UNCHECKED);
								           }
                                     if(symbol_length == 3)
                                           {
                                            symbol_length = 2;                                    
								            sprintf(response,"%s"," 3 baud");
								            CheckMenuItem(menu,IDM_6_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_45_BAUD,MF_UNCHECKED);
                                            CheckMenuItem(menu,IDM_3_BAUD,MF_CHECKED);
				                            CheckMenuItem(menu,IDM_2_BAUD,MF_UNCHECKED);
								           }


                                     int len;
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)response);  
    
                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                     
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
                               
                                    }
							         goto skip0;
                                  }

//********************************************************************************************************************************************               
//"Decrease baud rate" command - reply with confirmation if changed, or OK if already there

                         if(Message_buffer[start+strlen(callsign)]=='<') 
				                  { 
					                {
							         KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
				                     unsigned char response[3] = "";

                                     if(symbol_length == 3) sprintf(response,"%s"," 2 baud");
                                    
                                     if(symbol_length == 2)
                                           {
                                            symbol_length = 3;                                    
								            sprintf(response,"%s"," 2 baud");
								            CheckMenuItem(menu,IDM_6_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_45_BAUD,MF_UNCHECKED);
                                            CheckMenuItem(menu,IDM_3_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_2_BAUD,MF_CHECKED);
								           }
                                     if(symbol_length == 1.5)
                                           {
                                            symbol_length = 2;                                    
								            sprintf(response,"%s"," 3 baud");
								            CheckMenuItem(menu,IDM_6_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_45_BAUD,MF_UNCHECKED);
                                            CheckMenuItem(menu,IDM_3_BAUD,MF_CHECKED);
				                            CheckMenuItem(menu,IDM_2_BAUD,MF_UNCHECKED);
								           }
                                     if(symbol_length == 1)
                                           {
                                            symbol_length = 1.5;                                    
								            sprintf(response,"%s"," 4.5 baud");
								            CheckMenuItem(menu,IDM_6_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_45_BAUD,MF_CHECKED);
                                            CheckMenuItem(menu,IDM_3_BAUD,MF_UNCHECKED);
				                            CheckMenuItem(menu,IDM_2_BAUD,MF_UNCHECKED);
								           } 


                                   
                                     int len;
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)response); 
    
                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                     
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
                             //        SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
						            }
							         goto skip0;
                                  }                           
//********************************************************************************************************************************************               
//"Polling/Query" command - reply with signal-to-noise ratio

						if(Message_buffer[start+strlen(callsign)]=='?')
					 			  { 
					                {
                                     KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
                          
                                     int len;
 
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)snr);   //Send the S/N reading as a reply (not calibrated though)
  
                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                     
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]); 
                               //      SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);  //print message to receive screen
                                    }                             
                                     goto skip0;
                                  }
//********************************************************************************************************************************************               
//"Squelch level" command - reply with current squelch level setting

						if(Message_buffer[start+strlen(callsign)]=='_')
					 			  { 
					                {
                                     KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
                          
                                     int len;
								     float squelch_dB;
                                     char SQL[32];
								     squelch_dB  = (415 - squelch_level)/2.7 - 5;
                                     sprintf(SQL, " squelch=%d%s",(int)squelch_dB," dB"); //save S/N for use later, when squelch has closed and signal has gone 
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)SQL);   //Send the squelch setting as a reply
  
                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                     
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]); 
                               //      SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);  //print message to receive screen
                                    }                             
                                     goto skip0;
                                  }

//********************************************************************************************************************************************               
//"Software version" command - reply with software version ratio

						if(Message_buffer[start+strlen(callsign)]=='^')
					 			 { 
					                { 
						             KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
                          
                                     int len;
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)software_version);   //Send the S/N reading as a reply (not calibrated though)

                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                     
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
                                    } 
                                     goto skip0;
                                 }
//********************************************************************************************************************************************
//"Where are you at (@)?" command - reply with location (eventually GPS, or perhaps just from menu?)

                         if(Message_buffer[start+strlen(callsign)]=='@') 
				                 {                  
						            { 
					                 KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
	                
					                 unsigned char qth[20]="";           //Another in which to put the received callsign  
                                     sprintf(qth, " %s", location);      //need to do this to ensure a space after the callsign 
				
                                     int len;
			                    
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)qth); 
    
                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                      
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);                                    
                                //    SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
	                                }					        
                                    goto skip0;
                                 }                               

//********************************************************************************************************************************************
//"Get message" command - reply with QTC message

                         if(Message_buffer[start+strlen(callsign)]=='&') 
				                 { 
					                 
						            {
							         KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
	                
					                 unsigned char qtc[1000]="";           //Another in which to put the received callsign  
                                     sprintf(qtc, " %s", cq_text);      //need to do this to ensure a space after the callsign 
				
                                     int len;
			                    
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)qtc); 
    
                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                    
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
                               
                               //       SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
						            }
                                     goto skip0;
                                 }                               
				
//********************************************************************************************************************************************
//"Get heard list" command - reply with calls in heard list (this is not going to print if your own call is in the heard list - which it could be at the very end!!!!)

                         if(Message_buffer[start+strlen(callsign)]=='$') 
				                 { 
					                 
						            {
							         KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);

                                     char LF[2];
							         int lf = 10;        
							         sprintf(LF,"%c",lf);	                
					                 unsigned char calls_heard[1000]=" Heard ";
                                     unsigned char call[1000]="";					   
							                                        
					                 strcat(calls_heard,LF);

                                     int nItems,k;
						             nItems = SendMessage (hwndList, LB_GETCOUNT , 0, 0);

                                     for(k=1;k<nItems;k++)                                              
					         	         { 
						                  SendMessage(hwndList, LB_GETTEXT, (WPARAM)k , (LPARAM)call);
									      strcat(calls_heard,call);
									      strcat(calls_heard,LF);
                                         } 
                                        
											
                                     int len;
			                    
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)calls_heard); 
    
                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  

					                    
							              int crlf;
	                                      crlf=10;
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
                               
                               //       SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start+strlen(callsign)+1]);
						            }
                                     goto skip0;
                                 }                               
								







 
//********************************************************************************************************************************************
//"Repeat message" command (Don't print this to recipient screen as it is relaying stuff elsewhere)

                         if(Message_buffer[start+strlen(callsign)]=='!')                                                                                                                              
				                    { 
                                         { 
					 
					                       KillTimer(hwnd,1);        //Stop the timer if it has failed to send a reply message
					                       SetFocus(hCtl_TX);
                                           int len;

                                           SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                           SendMessage(hCtl_TX, EM_REPLACESEL, len+1, (LPARAM)&Message_buffer[start+strlen(callsign)+1]);//and the message, everything after your own call                                                                
                         
                                     int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
							
				                          }
							           goto skip0;   
		                            }

//********************************************************************************************************************************************
//"Delayed Repeat message" command (to ensure a relay request does not occur before later non-! ones)

                         if(Message_buffer[start+strlen(callsign)]=='~')                                                                                                                              
				                    { 
                                         { 
					 
					                       KillTimer(hwnd,1);        //Stop the timer if it has failed to send a reply message
					                       SetFocus(hCtl_TX);
                                           int len;

                                           len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                           SendMessage(hCtl_TX, EM_REPLACESEL, len+1, (LPARAM)&Message_buffer[start+strlen(callsign)+1]);//and the message, everything after your own call
                    
                                     int starts = (crc_callfound + crc) * 10 + 12000;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							                                           // to give a range between 510 and 3050 msec (add 500 in case crc is too small)
 					                 SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
					     	
				                          }
							           goto skip0;   
		                            }


//********************************************************************************************************************************************
//ALLCALL "Save message to file" command 
                     //   if((Message_buffer[start1+strlen("allcall")]=='#')&&(strstr(&Message_buffer[start1],"allcall")!=0))   
                        if(strstr(&Message_buffer[start1],"allcall#")!=0) 
				                    {
						               int crlf;
	                                   crlf=10;
                                     if(Message_buffer[start1+strlen("allcall")+1] == '[')  //If we find the opening bracket, search for the closing one...
                                      {
                                        int i;
						                for(i = 0;i < 256;i++)  
							               {
							                if(Message_buffer[start1+strlen("allcall")+1+i] == ']')    //Found it!
								                { 
									              static int filename_len;
                                                  filename_len = i+1;
									              unsigned char filenumber[256];// = {'\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0'};
							                      int n;
                                                  for(n=0;n<256;n++) filenumber[n]='\0';  //flush the buffer with nulls

							                      strncpy(filenumber,&Message_buffer[start1+strlen("allcall")+1],filename_len);
							                      sprintf(filename,"%s",filenumber);
                 
                                                            
                                                  char temp_filename[256];//strip off the [ and ] from the incoming filename - No! This screws it up elsewhere.
                                                  for(n=0;n<256;n++) temp_filename[n]='\0';  //flush the buffer with nulls
										          for(n=0;n<256;n++) new_filename[n]='\0';  //flush the buffer with nulls
                                                  strcpy(temp_filename,&filename[1]);
                                                  strncpy(new_filename,temp_filename,strlen(temp_filename)-1);

                                          //test for illegal characters which indicate an attempt to access a different file path
										          char *p = strchr(new_filename, '\\' );
										          char *q = strchr(new_filename, '/' );
                                                  if ((p != 0)|(q != 0))
										          {
											       goto send_error_message_2;
										          }
											       else
										          {

										 //Test for presence of "-" indicating that it is a telemetry frame. Add timestamp and SNR if it is.
                                                  char *r = strchr(new_filename, '-' );
												  char TSandSNR[256];
                                                  if ((r != 0) & (AddTimestampandSNR == TRUE))
                                                  	{
                                                   //code for timestamp and snr;
                               						 	SYSTEMTIME Time_stamp;
                                					 	GetLocalTime(&Time_stamp);   
 														sprintf(TSandSNR, "%02d:%02d%#3d", Time_stamp.wHour, Time_stamp.wMinute, (int)SNR);
													}
													else
													{
														sprintf(TSandSNR, "\0");
													}

										//All good; save to file! 
                                 			       sprintf(path_plus_filename,"%s\\%s",full_incoming_path,new_filename); //add the path to "Shared" folder
                                                   savefile = fopen(path_plus_filename, "a");     //Open a file for appending incoming text 

                                                   char file_crlf[32000];
							                       sprintf(file_crlf,"%s%s\n",TSandSNR, &Message_buffer[start1+strlen("allcall")+1+filename_len]);//adds a new line (\n)
							                                        
					                               fprintf(savefile, "%s", file_crlf);
                                                   fclose(savefile);

  //Save raw data to file if required.... 
 
    char *suffix2 = strstr(path_plus_filename, ".enc");  //Look for a ".enc" suffix
    if (suffix2 != 0)	                                //if found, then transfer raw samples to file																							
    {
    	FILE *RSdata2;
		int nx2=0;
		char str2[400000] = {'\0'};
 		sprintf(str2,"%s","");                           //make sure string does not have junk in it
		char RS_data_path2[256];
    	sprintf(RS_data_path2, "%s%s",path_plus_filename, ".RS");  //add .RS suffix to file so it is recognised by the decoder helper program

//char num2[20];
//sprintf(num2,"%d",sample_index);
//SetWindowText(hwnd,num2);

 //Open a file for appending incoming text
    	RSdata2 = fopen(RS_data_path2, "w"); 
    	char s2[1];
		for (nx2=0;nx2<sample_index;nx2++)     //allow for up to 4k of characters, at 12 samples per symbols = 48000 or so
    	 {
		  sprintf(s2,"%d,",sample_buffer[nx2]);
	 	  strcat(str2,s2);
		 }											
		  fprintf(RSdata2, str2);
    	  fclose(RSdata2);
	}

     Save_RS_data = FALSE;   //reset just in case
	 for (sample_index=0;sample_index<400000;sample_index++)sample_buffer[sample_index] = 0 ;
     sample_index = 0; 
 //	 SAVE_FILE = FALSE;
	// SendMessage(g_hwndSAVEbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSAVE_OFF);


                                                   MSGRX = TRUE;

                                       //Test again for presence of "-" indicating that it is a telemetry frame. Don't send an "ack" if it is.
                                              //    char *r = strchr(new_filename, '-' );
                                                  if (r != 0)
                                                  {
                                                   goto no_ack2;
                                                  }
                                                    else
                                                    {
                                                     goto quit_loop;
                                                    }
                                                  }
                                                }
                                           }                


quit_loop:						    
                           //Send confirmation of receipt of file back to originating station
					                 KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                 SetFocus(hCtl_TX);
	                
					                 int len;
			                    
                                     SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                     len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH,0, 0);
                                     SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" ack");  //need a space so that the receiver can recognise own call                                     
    
                                        //Start a timer and then TX after squelch has closed
                                        srand((int)clock());
                                        int starts = 500 + rand() % 3000;
                                        SetTimer(hwnd, 1, starts, NULL);         
                                   
no_ack2:							       
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
						                  SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)&crlf);
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)call_found); //append call_found to the neginning of the received message
                                          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM)":");      // so it looks just like FSQ replies (good for roundtable QSO's)                               
								          len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                                          SendMessage(hCtl, EM_REPLACESEL, len, (LPARAM) &Message_buffer[start1+8]);

                                      
							      //        SendMessage(hwndRXfile, EM_REPLACESEL, 0, (LPARAM) &Message_buffer[start1+8]);//echo received text to RXfile tab
								  //        len = SendMessage(hwndRXfile, WM_GETTEXTLENGTH, 0, 0);
						          //        SendMessage(hwndRXfile, EM_REPLACESEL, len, (LPARAM)&crlf);

                                     PostMessage(g_hwndMSGRXbutton,WM_LBUTTONDOWN,0,0);         //Auto-press "MSG_RX" button to light it up red
                                                                                                //to let user know that incoming message has been saved                                                                 
								//Update the accessible file list
                                        ListShortDirectoryContents(full_incoming_path, FilesShortindexpath);
                                        ListLongDirectoryContents(full_incoming_path, FilesLongindexpath);
                                        ListShortDirectoryContents(full_image_path, Imageindexpath);
                                                                                                   
                                      }  
						              goto skip0;

send_error_message_2:                   //Send confirmation of receipt of file back to originating station
					                    KillTimer(hwnd,1);                    //Stop the timer if it has failed to send a reply message
					                    SetFocus(hCtl_TX);
	                
					                    int len;
			                    
                                        SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)call_found); //send the message to the TX box ready to transmit
                                        len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                                        SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" Illegal filename");//need a space so that the receiver can recognise own call                                     

                                        //Start a timer and then TX after squelch has closed
                                        srand((int)clock());
                                        int starts = 500 + rand() % 3000;
                                        SetTimer(hwnd, 1, starts, NULL);         
								    
                                     //   int starts = (crc_callfound + crc) * 10 + 500;	   //crc and crc_callfound gives some randomisation and is a number between 1 and 255 therefore multiply by 10 
							         //   SetTimer(hwnd, 1, starts, NULL);   //Start a timer and then TX after squelch has closed  
						            goto skip0;

                                    }                                 
	

                      }
skip0:
			          for (n=0;n<32000;n++)Message_buffer[n]='\0';    //flush the buffer with nulls 
                      if(FSQCAL == TRUE)SendMessage(g_hwndFSQCALbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSELCAL_ON);//turn FSQCAL button blue again 
                      CALL_FOUND = FALSE; 
				
                    
			} //end of "if((signoise>squelch_level)&&(CALL_FOUND == TRUE))"
                     

//========================================================================================
//=======   Set the raw sample buffer index to 0 to avoid rubbish piling up    ===========
//========================================================================================

if (signoise>squelch_level)sample_index = 0;  //keep setting the buffer index to zero unless squelch opens
											  //this prevents junk from accummulating from other SELCAL's	


//Note: This has to go at the end, otherwise if squelch opens it will clear the buffer and there won't be anything to save


//End of varidecoder
skip: 
           prev_symbol = symbol;
 
//;
    	}

   }


		
  } 
		return 0; // a non-zero return will stop the stream
}



/*------------------------------------------------------------------------------
 *
 *      Audio stream callback function
 *
 *      All audio processing is done in this function!
 *
 *      (No need to mess with a separate worker thread since this is
 *      already taken care of by PortAudio!)
 */

static int SendAudioCallback (void *inputBuffer,
                          void *outputBuffer,
                          unsigned long framesPerBuffer,
                          PaTimestamp outTime,
                          void *userData)
{
  unsigned long frameCnt;
  float *out = (float *) outputBuffer;
//  float *in = (float *) inputBuffer;

  //int i, j;
  static int k; 
// static unsigned short ln, hn;
  static unsigned char ch, ch2;    //<<<<*******MUST be "unsigned char" to accommodate the ascii codes >127 *********
  static float phase, send, fAngle;
  static short curslot, prevslot;
  static short tone, prevtone;
  int n1, n2;
  int len, remaining;
//  static int pause=0;

char buffer[34]; //to convert tone value into a character


//********************************************************//Used with image mode below 
  remaining = GetWindowTextLength(hCtl_TX) + 1;           
//********************************************************//(this bit MUST go here, before the for loop)


  for (frameCnt = 0; frameCnt < framesPerBuffer; frameCnt++)
    {



//**************************************************************
//Send picture only if there is nothing left in the text buffer
//(This causes a trailing "click" for some reason - see below)
//**************************************************************	
  if((Image_mode == TRUE)&(remaining<2))
     {
      send = modulate_image();

      *out++ = send;
      *out++ = send;
      goto skip_image;
     }
//********************************************************
//      END OF IMAGE STUFF
//********************************************************





//********************************************************
// Normal text mode
//********************************************************			      
     if(k++ >= FFT_SIZE_IN * symbol_length)         //get a new character every 0.341/2 seconds (note that k is counted twice in this routine)

		{
         k=0;
         len = GetWindowTextLength(hCtl_TX) + 1;      // add 1 for the final NULL
       
//If no more text to send switch to receive
       if(len<2) PostMessage(g_hwndRXbutton,WM_LBUTTONDOWN, 0, 0) ;  //Is this legal?? BM_CLICK does not work with "static" controls, only "button" class
//                                                                     Use PostMessage instead of Sendmessage to give buffer a chance to flush,
//else                                                                 otherwise we hear a subsequent tone "click"
         if (len > 1)
            {
             char buf[len];
             
             GetWindowText(hCtl_TX, buf, len);
         //... do stuff with text ...
             ch  = buf[0];                          //get first character in buffer
       

    n1 = (unsigned int) wsq_varicode[ch][0];
    n2 = (unsigned int) wsq_varicode[ch][1];

/*check if varicode is picking up ascii codes >127
char txt[2];
sprintf(txt, "%d:%d:%d\n",(unsigned char)ch, n1,n2);
SetWindowText (hwnd,txt);
*/

//With varicode
         
			 tone = (prevtone + n1 + 1) % 33;

             SetWindowText(hCtl_TX, &buf[1]);  //move the text to send along one as we remove the first character
             SendMessage(hCtl_TX, EM_SETSEL, len, len); //put caret at end of text

//if(SOUNDING == TRUE)goto skip_echo;  //don't echo the callsign when sounding

       //echo the sent character to the receive screen
		
            if(buf[0]==13) goto NoExtraLF;     //echo only the CR - don't print the BS (EOT) character        
            if(buf[0]==8) goto skip_echo;                                                  //from received text

           int text_length = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);  
           SendMessage(hCtl, EM_SETSEL, text_length, text_length);

  cf.cbSize      = sizeof(cf);       //Length of structure
  cf.dwMask      = CFM_COLOR;        //Set mask to colors only
  if(Text_colour == TRUE)
		{
         cf.crTextColor = RGB(220,0,0);      //Set the new colour value 
        }
  else
        {
         cf.crTextColor = RGB(0,0,0);      //Set the colour back to black 
        }    
  SendMessage(hCtl, EM_SETCHARFORMAT, SCF_SELECTION,(LPARAM) &cf);

           SendMessage (hCtl, EM_REPLACESEL,  0, (LPARAM)&ch);  
           SendMessage (hCtl, EM_SCROLLCARET, 0, 0 ); 
	       SendMessage (hwnd, WM_MOUSEMOVE,   0, 0);                 //counteract it by forcing a mouse move    

skip_echo:

         //   SendMessage ( hCtl, WM_CHAR, buf[0], 0);      //This hides the cursor so              
NoExtraLF:  SendMessage ( hwnd, WM_MOUSEMOVE, 0, 0);        //counteract it by forcing a mouse move

            }
        }

	     phase  = 2*3.14159*(1000 + channel_offset + tone*2.9296875*tone_spacing)/FS;//7.8125*1.5)/FS;//2.9296875*4) / FS;     //tones are 3 FFT bins apart tone spacing = 1.5 times 1/T
	     send   = sin(fAngle);
         fAngle = fAngle + phase;
	   	 if(fAngle>=(2*3.14159))fAngle = fAngle - 2*3.14159;    

                 *out++ = send;      
                 *out++ = send;

	     prevtone = tone;
         prevslot = curslot;


      if(k++ >= FFT_SIZE_IN * symbol_length)                  //this is where k is counted twice therefore baud rate is twice what it seems
		   
        {	 
         if((int) wsq_varicode[ch][1] > 28)                  //now do the lower nibble for JASON mode
		   {
            k=0;    
            tone = (prevtone + (int) wsq_varicode[ch][1]+ 1) % 33;

            prevtone = tone;
           }

        } 

         tone_number = tone;



skip_image:
 ;           //<-- needs a trailing ";" to avoid compiler error message
   }

		return 0; // a non-zero return will stop the stream
}




/*------------------------------------------------------------------------------
 *
 *      Start Portaudio 
 */

void Start_Portaudio()
            {
                  char szErr80[84];                   
                  PaError PaInitresultCode;                         
                  Pa_StopStream (g_PAStream);    
                  Pa_Sleep( 500 );        //wait a while before restarting
                  
                 // Re-Initialize PortAudio subsystem

                 PaInitresultCode = Pa_Initialize ();
                 if (PaInitresultCode == paNoError)
                {

                   PaInitresultCode = Pa_OpenStream(
                       &g_PAStream,
                       soundcard_in_ID,
                       2,
                       paFloat32,
                       NULL,//void *inputDriverInfo,
                       soundcard_out_ID,
                       2,
                       paFloat32,
                       NULL,
                       FS,
                       FPB,
                       0,
                       0,
                       AudioCallback,
                       NULL );


                if (PaInitresultCode == paNoError)
                  PaInitresultCode = Pa_StartStream (g_PAStream);
               }

               if (PaInitresultCode != paNoError)
               {
                 Pa_Terminate();
                 if (PaInitresultCode == paHostError)
                 {
                   MessageBox (hwnd, szErr80, "Portaudio input error", MB_APPLMODAL | MB_OK | MB_ICONEXCLAMATION);
                   PostQuitMessage (1);
                 }
                 else
                 {
                   MessageBox (hwnd, Pa_GetErrorText(PaInitresultCode), "Portaudio input error",
                               MB_APPLMODAL | MB_OK | MB_ICONEXCLAMATION);
                   PostQuitMessage (1);
                 }                 
               }
	
               }    

void Start_Portaudio_Send()
            {
                  char szErr80[84];                   
                  PaError PaInitresultCode;                         
                  Pa_StopStream (g_PAStream_Send);    
                  Pa_Sleep( 500 );        //wait a while before restarting
                  
                 // Re-Initialize PortAudio subsystem

                 PaInitresultCode = Pa_Initialize ();
                 if (PaInitresultCode == paNoError)
                {
 
                   PaInitresultCode = Pa_OpenStream(
                       &g_PAStream_Send,
                       soundcard_in_ID,
                       2,
                       paFloat32,
                       NULL,//void *inputDriverInfo,
                       soundcard_out_ID,
                       2,
                       paFloat32,
                       NULL,
                       FS,
                       FPB,
                       0,
                       0,
                       SendAudioCallback,
                       NULL );





                if (PaInitresultCode == paNoError)
                  PaInitresultCode = Pa_StartStream (g_PAStream_Send);
               }

               if (PaInitresultCode != paNoError)
               {
                 Pa_Terminate();
                 if (PaInitresultCode == paHostError)
                 {
                   MessageBox (hwnd, szErr80, "Portaudio output error", MB_APPLMODAL | MB_OK | MB_ICONEXCLAMATION);
                   PostQuitMessage (1);
                 }
                 else
                 {
                   MessageBox (hwnd, Pa_GetErrorText(PaInitresultCode), "Portaudio output error",
                               MB_APPLMODAL | MB_OK | MB_ICONEXCLAMATION);
                   PostQuitMessage (1);
                 }                 
               }
	
               }      






/*------------------------------------------------------------------------------
 *
 *      Reaction to WM_PAINT message  (some of which is "borrowed" from SAQrx)
 */

#define SPECFRAMEWIDTH  600
#define SPECFRAMEHEIGHT 400
#define CURVEHEIGHT     221
#define CURVESTARTX     60
#define CURVESTARTY     40+CURVEHEIGHT

#define SPECTRUM_MIN_DB -110.0
#define SPECTRUM_MAX_DB 0.0

LONG OnWmPaint (HWND hWnd)
 {

 
     
  float SignalStrength;
  float scale_offset = channel_offset/2.9296875;

  int pixel_brightness, red, green, blue;


  HDC hDC;

  
  hDC = BeginPaint (hWnd, &ps);

  // Get the size of the program window's client area:
  //
  // NOTE! The coordinates returned by GetClientRect() are:
  //
  //   rctClientArea.left == rctClientArea.top == 0 (always)
  //
  //   rctClientArea.right = WIDTH of client area
  //   (rightmost visible X == rctClientArea.right-1
  //
  //   rctClientArea.bottom = HEIGHT of client area
  //   (bottommost visible Y == rctClientArea.bottom-1

 GetClientRect (hWnd, &rctClientArea);


 bottom_offset = rctClientArea.bottom - 518;
 right_offset  = rctClientArea.right  - 925;
//
  graph_rect.left      = 0;                   //set up limited rectangle to invalidate 
  graph_rect.top       = bottom_offset+362;    
  graph_rect.bottom    = bottom_offset+480;  //Allow for ftrequency scale markers to be included
  graph_rect.right     = 362;               //We have a smaller area for the waterfall when FQSCAL is operative

  commands_rect.left   = 135;             //set up limited rectangle to invalidate
  commands_rect.top    = bottom_offset+489;
  commands_rect.right  = 360;     
  commands_rect.bottom = bottom_offset+513;

 
  // Create a compatible device context (DC) for drawing off-screen:

  hdcMem = CreateCompatibleDC (((LPPAINTSTRUCT)(&ps))->hdc);
  
  // Create an off-screen bitmap to do the off-screen drawing on:

  hbmMem = CreateCompatibleBitmap (((LPPAINTSTRUCT)(&ps))->hdc,
                                   rctClientArea.right-rctClientArea.left,
                                   rctClientArea.bottom-rctClientArea.top);
 
  // Direct all drawing operations onto the off-screen bitmap:

  hbmOld = (HBITMAP) SelectObject (hdcMem, hbmMem);





 
  // We can now begin the drawing operations, first erase the background:

  FillRect (hdcMem, &rctClientArea, (HBRUSH) GetStockObject(DKGRAY_BRUSH));


  SetBkMode(hdcMem, TRANSPARENT);  //so that numbers don't have white boxes around them



  // Draw spectrum plot:

  hPen = CreatePen (PS_SOLID, 1, 0x00DDDDDD);//0x0000FF10L);
  hOldPen = (HPEN)SelectObject (hdcMem, hPen);


  SignalStrength = 0;    //Reset S meter to zero
  
  for (iXLoop = 0; iXLoop < 950; iXLoop+=1)
  {

      pixel_brightness =  (int) (g_fltPlotFftV[iXLoop] * bright * bright/500);

   
  if(Blue == TRUE)                        // Blue waterfall display
		{
         red = pixel_brightness;
         green = pixel_brightness * 256;
         blue = (pixel_brightness) * 256 * 256 * 2;
		}
	else                                  // Green waterfall display
		{
         red = pixel_brightness;
         green = pixel_brightness * 256 * 2;
         blue = (pixel_brightness) * 256 * 256;
		}


  
      if (red >255) red = 255;
      if (green >256*255) green = 256*255;
      if (blue >256*256*255) blue = 256*256*255;

      if(((g_PlotPeak[iXLoop] == 255) & (symbol_marker == TRUE)))
	 //mark the peaks in  yellow
		{
			red  = 255;
			green= 256*255;
			blue = 0;
		}
      
      brightness[iXLoop] = red + green + blue;  //save the amplitude for waterfall pixels later on 
      if (brightness[iXLoop]>16777215) brightness[iXLoop]=16777215;
  
      
  } // end for X...


//*************************************************************************************
//          Draw waterfall  
//*************************************************************************************
 int waterfall_start, waterfall_end, blit_end;
 
/* if(FSQCAL_CREATE == FALSE)
	{
	 waterfall_start = 43;//+scale_offset;
	 waterfall_end   = 798;//+scale_offset;
     blit_end        = 755;//+scale_offset;
	}
	else
	{
*/     waterfall_start = 255+scale_offset;
     waterfall_end   = 600+scale_offset;
     blit_end        = 300;//+scale_offset;
//	}
     
 for (iXLoop = waterfall_start; iXLoop < waterfall_end; iXLoop++)  //move it over to the left
  {
    SetPixelV (hdcScroll, iXLoop-waterfall_start, 0, brightness[iXLoop]);  
  }   
 
  BitBlt(hdcScroll,
         0,0, waterfall_end, 85,
         hdcScroll,
         0, -1,
         SRCCOPY); 



//move the waterfall down one line and blit it to memory
  BitBlt(hdcMem,
         60, bottom_offset+370, blit_end, 85,
         hdcScroll,
         0, 0,   //<--1 to avoid showing the first line being updated??? seems OK to me
         SRCCOPY);


//Display the received peak frequencies and the sent tones:

 //  SetTextColor (hdcMem, 0x0000A0A0);  //dark yellow
 

 

 

 HANDLE vertFont,hOldFont;
  vertFont = CreateFont( 
          15,0,//   'height,width(default=0)
          900,0, //  'escapement(angle),orientation (1/10 degree)
          400, //_    'weight (default=0,normal=400,bold=700)
          FALSE, //_ 'Italic
          FALSE, //_ 'Underline
          FALSE, //_ 'StrikeThru
          ANSI_CHARSET, OUT_CHARACTER_PRECIS,// _
          CLIP_DEFAULT_PRECIS, PROOF_QUALITY,//_
          FIXED_PITCH | FF_MODERN,"Courier New" );

    hOldFont = SelectObject(hdcMem,vertFont);
    SetTextColor(hdcMem, 0x00F0C080); 
 //   TextOut (hdcMem, 10,450, "Brightness", 10);

    DeleteObject (SelectObject (hdcMem,hOldFont));


//************************************************************************************
//  Draw waterfall display box and markers 
//************************************************************************************

if(FSQCAL_CREATE == FALSE)              //For "normal" FSQ with no options pane or listbox
 {
  SetTextAlign (hdcMem, TA_RIGHT);
  SetTextColor(hdcMem, 0x00808080);
  hPen = CreatePen (PS_SOLID, 1, 0x00808080);
  hOldPen = (HPEN)SelectObject (hdcMem, hPen);

    
    MoveToEx (hdcMem, CURVESTARTX-6,  bottom_offset+ CURVESTARTY+105, NULL);
    LineTo (hdcMem, CURVESTARTX+760, bottom_offset+  CURVESTARTY+105);
    LineTo (hdcMem, CURVESTARTX+760,  bottom_offset+ CURVESTARTY+198);
    LineTo (hdcMem, CURVESTARTX-6,   bottom_offset+  CURVESTARTY+198);
    LineTo (hdcMem, CURVESTARTX-6,   bottom_offset+  CURVESTARTY+105);

//Add frequency markers
  MoveToEx (hdcMem,85,bottom_offset+459 , NULL);  //waterfall frequency markers  200Hz
  LineTo   (hdcMem,85, bottom_offset+465 );

  MoveToEx (hdcMem,153,bottom_offset+459 , NULL);  //                            400Hz
  LineTo   (hdcMem,153,bottom_offset+ 465 );

  MoveToEx (hdcMem,221,bottom_offset+459 , NULL);  //                            600Hz
  LineTo   (hdcMem,221, bottom_offset+465 );

  MoveToEx (hdcMem,289,bottom_offset+459 , NULL);  //                            800Hz
  LineTo   (hdcMem,289, bottom_offset+465 );

  MoveToEx (hdcMem,358,bottom_offset+459 , NULL);  //                            1000Hz
  LineTo   (hdcMem,358,bottom_offset+ 465 );

  MoveToEx (hdcMem,426,bottom_offset+459 , NULL);  //                            1200Hz
  LineTo   (hdcMem,426, bottom_offset+465 );

  MoveToEx (hdcMem,494,bottom_offset+459 , NULL);  //                            1400Hz
  LineTo   (hdcMem,494, bottom_offset+465 );

  MoveToEx (hdcMem,563,bottom_offset+459 , NULL);  //                            1600Hz
  LineTo   (hdcMem,563, bottom_offset+465 );

  MoveToEx (hdcMem,631,bottom_offset+459 , NULL);  //                            1800Hz
  LineTo   (hdcMem,631,bottom_offset+ 465 );

  MoveToEx (hdcMem,700,bottom_offset+459 , NULL);  //                            2000Hz
  LineTo   (hdcMem,700, bottom_offset+465 );

  MoveToEx (hdcMem,768,bottom_offset+459 , NULL);  //                            2200Hz
  LineTo   (hdcMem,768,bottom_offset+ 465 );


//Add frequency labels
 TextOut (hdcMem, 100,bottom_offset+ 465, " 200", 4);
 TextOut (hdcMem, 168,bottom_offset+ 465, " 400", 4);
 TextOut (hdcMem, 236, bottom_offset+465, " 600", 4);
 TextOut (hdcMem, 304,bottom_offset+ 465, " 800", 4);
 TextOut (hdcMem, 373, bottom_offset+465, "1000", 4);
 TextOut (hdcMem, 441,bottom_offset+ 465, "1200", 4);
 TextOut (hdcMem, 511,bottom_offset+ 465, "1400", 4);
 TextOut (hdcMem, 578, bottom_offset+465, "1600", 4);
 TextOut (hdcMem, 646, bottom_offset+465, "1800", 4);
 TextOut (hdcMem, 715,bottom_offset+ 465, "2000", 4);
 TextOut (hdcMem, 803, bottom_offset+465, "2200 Hz", 7);

}
else                                           //FSQCAL turned ON, and watefall adjusted to suit
{

  // Redraw waterfall display box and markers

  SetTextAlign (hdcMem, TA_RIGHT);
  SetTextColor(hdcMem, 0x00808080);
  hPen = CreatePen (PS_SOLID, 1, 0x00808080);
  hOldPen = (HPEN)SelectObject (hdcMem, hPen);

    
    MoveToEx (hdcMem, CURVESTARTX-6,  bottom_offset+ CURVESTARTY+105, NULL);
    LineTo (hdcMem, CURVESTARTX+305,  bottom_offset+ CURVESTARTY+105);
    LineTo (hdcMem, CURVESTARTX+305,  bottom_offset+ CURVESTARTY+198);
    LineTo (hdcMem, CURVESTARTX-6,    bottom_offset+ CURVESTARTY+198);
    LineTo (hdcMem, CURVESTARTX-6,    bottom_offset+ CURVESTARTY+105);

//Add frequency markers
if(channel_offset == 350)
    {
 //    MoveToEx (hdcMem,76-scale_offset,459 , NULL);  //waterfall frequency markers   800Hz
 //    LineTo   (hdcMem,76-scale_offset, 465 );

 //    MoveToEx (hdcMem,145-scale_offset,459 , NULL);  //                            1000Hz
 //    LineTo   (hdcMem,145-scale_offset, 465 );

     MoveToEx (hdcMem,211-scale_offset,bottom_offset+459 , NULL);  //                            1000Hz
     LineTo   (hdcMem,211-scale_offset, bottom_offset+465 );

     MoveToEx (hdcMem,283-scale_offset,bottom_offset+459 , NULL);  //                            1200Hz
     LineTo   (hdcMem,283-scale_offset, bottom_offset+465 );

     MoveToEx (hdcMem,350-scale_offset,bottom_offset+459 , NULL);  //                            1400Hz
     LineTo   (hdcMem,350-scale_offset, bottom_offset+465 );

     MoveToEx (hdcMem,423-scale_offset,bottom_offset+459 , NULL);  //                            1800Hz
     LineTo   (hdcMem,423-scale_offset, bottom_offset+465 );

//Add frequency labels

     TextOut (hdcMem, 230-scale_offset, bottom_offset+465, "1200", 4);
     TextOut (hdcMem, 300-scale_offset, bottom_offset+465, "1400", 4);
     TextOut (hdcMem, 370-scale_offset, bottom_offset+465, "1600", 4);
     TextOut (hdcMem, 440-scale_offset, bottom_offset+465, "1800", 4);
    }
		else
	{
     MoveToEx (hdcMem,76,bottom_offset+459 , NULL);  //waterfall frequency markers   800Hz
     LineTo   (hdcMem,76, bottom_offset+465 );

     MoveToEx (hdcMem,145,bottom_offset+459 , NULL);  //                            1000Hz
     LineTo   (hdcMem,145, bottom_offset+465 );

     MoveToEx (hdcMem,211,bottom_offset+459 , NULL);  //                            1200Hz
     LineTo   (hdcMem,211, bottom_offset+465 );

     MoveToEx (hdcMem,283,bottom_offset+459 , NULL);  //                            1400Hz
     LineTo   (hdcMem,283, bottom_offset+465 );

     MoveToEx (hdcMem,350,bottom_offset+459 , NULL);  //                            1600Hz
     LineTo   (hdcMem,350,bottom_offset+ 465 );


//Add frequency labels
  
     TextOut (hdcMem, 90, bottom_offset+465, " 800", 4);
     TextOut (hdcMem, 160, bottom_offset+465, "1000", 4);
     TextOut (hdcMem, 230,bottom_offset+ 465, "1200", 4);
     TextOut (hdcMem, 300,bottom_offset+ 465, "1400", 4);
     TextOut (hdcMem, 363, bottom_offset+465, "1600", 4);
	}
}



  // Put long box for "status bar" along the bottom for controls below

  MoveToEx (hdcMem,5,bottom_offset+488 , NULL);  
  LineTo   (hdcMem,right_offset+920, bottom_offset+488 );
  LineTo   (hdcMem,right_offset+920, bottom_offset+514 );
  LineTo   (hdcMem,5,bottom_offset+514 );
  LineTo   (hdcMem,5, bottom_offset+488 );

if(FSQCAL_CREATE == FALSE)
	{
  MoveToEx (hdcMem,642,488 , NULL);  //put separator markers
  LineTo   (hdcMem,642,514 );

  MoveToEx (hdcMem,412,488 , NULL);  //put separator markers
  LineTo   (hdcMem,412,514 );

	}

  MoveToEx (hdcMem,370,bottom_offset+488 , NULL);  //put separator markers
  LineTo   (hdcMem,370,bottom_offset+514 );

  MoveToEx (hdcMem,135,bottom_offset+488 , NULL);  //put separator markers
  LineTo   (hdcMem,135,bottom_offset+514 );


// Clean up

  SelectObject (hdcMem, hOldPen);
  DeleteObject (hPen);



 SetTextAlign (hdcMem, TA_LEFT);




//************************************************************************************
//           Display the S/N meter reading
//************************************************************************************

//   Sig_to_noise2 = 20*log10(Signal_to_Noise);  //not sure it should be 20log but that seems to agree with PATHSIM simulations

	
/*	
	char sign[9];
sprintf(sign,"%0.0f",  Sig_to_noise);
 SetWindowText(hwnd,sign);
*/ 
//First make the meter background box
  HBRUSH hBrush_SmeterBG = CreateSolidBrush (0x00505050);
  HBRUSH hOldSmeterBrushBG = (HBRUSH)SelectObject (hdcMem, hBrush_SmeterBG);   
  Rectangle (hdcMem, 5, bottom_offset+366, 30,bottom_offset+460);


  SelectObject (hdcMem, hOldSmeterBrushBG);
  DeleteObject (hBrush_SmeterBG);  
  
  
  HBRUSH hBrush_SmeterGreen = CreateSolidBrush (0x0000B000);
  HBRUSH hOldSmeterBrushGreen = (HBRUSH)SelectObject (hdcMem, hBrush_SmeterGreen);   
  SetBkMode(hdcMem, TRANSPARENT);

    if(signoise<366)signoise = 366;  //make sure green indicator rectangle stays wikthin the meter
    if(signoise>460)signoise = 460;
	
  Rectangle (hdcMem, 5, bottom_offset+signoise, 30, bottom_offset+460); 
  

  MoveToEx (hdcMem,5,bottom_offset+453 , NULL);  //-30dB
  LineTo (hdcMem,30, bottom_offset+453 );

  MoveToEx (hdcMem,5,bottom_offset+427 , NULL);  //-20dB
  LineTo (hdcMem,30,bottom_offset+ 427 );

  MoveToEx (hdcMem,5,bottom_offset+403 , NULL);  //-10dB
  LineTo (hdcMem,30, bottom_offset+403 );

  MoveToEx (hdcMem,5,bottom_offset+379 , NULL);  //0dB
  LineTo (hdcMem,30, bottom_offset+379 );

  
      
  hPen = CreatePen (PS_SOLID, 5, 0x0000FFFF);  //change to a fat yellow line for colour-blind people
  hOldPen = (HPEN)SelectObject (hdcMem, hPen);
 // SetBkMode(hdcMem, TRANSPARENT); 
  MoveToEx (hdcMem,5+2,bottom_offset+squelch_level , NULL);   //-25dB red marker
  LineTo (hdcMem,30-3, bottom_offset+squelch_level );



HANDLE SmeterFont,hOldSmeterFont;
  SmeterFont = CreateFont( 
          13,0,//   'height,width(default=0)
          0,0, //  'escapement(angle),orientation (1/10 degree)
          400, //_    'weight (default=0,normal=400,bold=700)
          FALSE, //_ 'Italic
          FALSE, //_ 'Underline
          FALSE, //_ 'StrikeThru
          ANSI_CHARSET, OUT_CHARACTER_PRECIS,// _
          CLIP_DEFAULT_PRECIS, PROOF_QUALITY,//_
          FIXED_PITCH | FF_MODERN,"Courier New" );

    hOldSmeterFont = SelectObject(hdcMem,SmeterFont);
    SetTextColor(hdcMem, 0x00FFFFFF);//0x00F0C080); 

    TextOut (hdcMem, 32,bottom_offset+448, "-20", 3);   
    TextOut (hdcMem, 32,bottom_offset+422, "-10", 3);       
    TextOut (hdcMem, 32,bottom_offset+398, "  0", 3);   
    TextOut (hdcMem, 32,bottom_offset+374, " 10", 3);   
    TextOut (hdcMem, 32,bottom_offset+363, " dB", 3); 

//Add label for signal-to-noise meter, for later on
  TextOut (hdcMem, 5, bottom_offset+462 , " Signal", 7);
  TextOut (hdcMem, 5, bottom_offset+474 , "to Noise", 8);

  TextOut (hdcMem, 90, bottom_offset+495 , "Bright", 6);


//************************************************************************************
//          Now display the baudrate bar graph (simulating a line of LED's)
//************************************************************************************

	static float Baudrate;
//	Baudrate = (int)(6.5*peaks_count);
//	if(Baudrate > 140)Baudrate = 140;

	Baudrate = (9.5*peaks_count);
	if(Baudrate > 221)Baudrate = 221;

  hPenGraph = CreatePen (PS_DOT, 1, 0x00888888);
  hOldPenGraph = (HPEN)SelectObject (hdcMem, hPenGraph);  //Draw grey dotted background graph

  MoveToEx (hdcMem,137+8,bottom_offset+495, NULL); 
  LineTo   (hdcMem,278+80,bottom_offset+495 );
  MoveToEx (hdcMem,137+8,bottom_offset+496, NULL); 
  LineTo   (hdcMem,278+80,bottom_offset+496 );
  MoveToEx (hdcMem,137+8,bottom_offset+497, NULL); 
  LineTo   (hdcMem,278+80,bottom_offset+497 );


  hPenSpeed = CreatePen (PS_DOT, 1, 0x00FF00);  //Now draw a green dotted line to represent the speed
  hOldPenSpeed = (HPEN)SelectObject (hdcMem, hPenSpeed);
 

  MoveToEx (hdcMem,137+8,bottom_offset+495 , NULL);               //print the dotted line three times to make it a bit fatter  
  LineTo   (hdcMem,137+8+(int)Baudrate, bottom_offset+495 );
  MoveToEx (hdcMem,137+8,bottom_offset+496 , NULL);  
  LineTo   (hdcMem,137+8+(int)Baudrate, bottom_offset+496 ); 
  MoveToEx (hdcMem,137+8,bottom_offset+497 , NULL);  
  LineTo   (hdcMem,137+8+(int)Baudrate,bottom_offset+ 497 );   
 
    TextOut (hdcMem, 144,bottom_offset+500, "Speed", 5);        //indicator labels
    TextOut (hdcMem, 197,bottom_offset+500, "6", 1);   
    TextOut (hdcMem, 229,bottom_offset+500, "4.5", 3);  
    TextOut (hdcMem, 284,bottom_offset+500, "3", 1);  
    TextOut (hdcMem, 340,bottom_offset+500, "2", 1);
  
if(Baudrate >74)
	{
  hPen45baud = CreatePen (PS_DOT, 1, 0x00FFFF);  //Now draw a yellow dotted line to represent 4.5 baud
  hOldPen45baud = (HPEN)SelectObject (hdcMem, hPen45baud);
 

  MoveToEx (hdcMem,137+82+4,bottom_offset+495 , NULL);               //print the dotted line three times to make it a bit fatter  
  LineTo   (hdcMem,137+82+4+(int)Baudrate-74, bottom_offset+495 );
  MoveToEx (hdcMem,137+82+4,bottom_offset+496 , NULL); 
  LineTo   (hdcMem,137+82+4+(int)Baudrate-74,bottom_offset+496 ); 
  MoveToEx (hdcMem,137+82+4,bottom_offset+497 , NULL);  
  LineTo   (hdcMem,137+82+4+(int)Baudrate-74, bottom_offset+497 );   
 }

if(Baudrate >114)
	{
  hPen3baud = CreatePen (PS_DOT, 1, 0x0088FF);  //Now draw a orange dotted line for 3 baud
  hOldPen3baud = (HPEN)SelectObject (hdcMem, hPen3baud);
 

  MoveToEx (hdcMem,137+122+6,bottom_offset+495 , NULL);               //print the dotted line three times to make it a bit fatter  
  LineTo   (hdcMem,137+122+6+(int)Baudrate-114, bottom_offset+495 );
  MoveToEx (hdcMem,137+122+6,bottom_offset+496 , NULL);  
  LineTo   (hdcMem,137+122+6+(int)Baudrate-114, bottom_offset+496 ); 
  MoveToEx (hdcMem,137+122+6,bottom_offset+497 , NULL);  
  LineTo   (hdcMem,137+122+6+(int)Baudrate-114, bottom_offset+497 );   
 }

if(Baudrate >156)
	{
  hPen2baud = CreatePen (PS_DOT, 1, 0x0000FF);  //Now draw a red dotted line for 2 baud
  hOldPen2baud = (HPEN)SelectObject (hdcMem, hPen2baud);
 

  MoveToEx (hdcMem,137+164+6,bottom_offset+495 , NULL);               //print the dotted line three times to make it a bit fatter  
  LineTo   (hdcMem,137+164+6+(int)Baudrate-156, bottom_offset+495 );
  MoveToEx (hdcMem,137+164+6,bottom_offset+496 , NULL);  
  LineTo   (hdcMem,137+164+6+(int)Baudrate-156, bottom_offset+496 ); 
  MoveToEx (hdcMem,137+164+6,bottom_offset+497 , NULL);  
  LineTo   (hdcMem,137+164+6+(int)Baudrate-156, bottom_offset+497 );   
 }

//************************************************************************************
//Clean up a bit
//************************************************************************************

    SelectObject (hdcMem, hOldSmeterBrushGreen);
    DeleteObject (hBrush_SmeterGreen); 
    DeleteObject (SelectObject (hdcMem,hOldSmeterFont));



          SelectObject (hdcMem, hPen);
          DeleteObject (hPen);
          SelectObject (hdcMem, hOldPen);
          DeleteObject (hOldPen);

          SelectObject (hdcMem, hPenGraph);
          DeleteObject (hPenGraph);
          SelectObject (hdcMem, hOldPenGraph);
          DeleteObject (hOldPenGraph);  

          SelectObject (hdcMem, hPenSpeed);
          DeleteObject (hPenSpeed);
          SelectObject (hdcMem, hOldPenSpeed);
          DeleteObject (hOldPenSpeed);  

          SelectObject (hdcMem, hPen45baud);
          DeleteObject (hPen45baud);
          SelectObject (hdcMem, hOldPen45baud);
          DeleteObject (hOldPen45baud);  

          SelectObject (hdcMem, hPen3baud);
          DeleteObject (hPen3baud);
          SelectObject (hdcMem, hOldPen3baud);
          DeleteObject (hOldPen3baud);  

          SelectObject (hdcMem, hPen2baud);
          DeleteObject (hPen2baud);
          SelectObject (hdcMem, hOldPen2baud);
          DeleteObject (hOldPen2baud);  


//************************************************************************************
// Draw IFK spectrum limit markers
//************************************************************************************

  int upper_marker, lower_marker;
 if(FSQCAL_CREATE == FALSE)
		{
		 upper_marker = 480+scale_offset;
	     lower_marker = 335+scale_offset;
	    }
  else
	    {
		 upper_marker = 270;
	     lower_marker = 115;
	    }

  hPen    = CreatePen (PS_SOLID, 1,  0x0000FFFF);
  hOldPen = (HPEN)SelectObject (hdcMem, hPen);

    MoveToEx (hdcMem, lower_marker, bottom_offset+370, NULL);
    LineTo   (hdcMem, lower_marker, bottom_offset+460 );

    MoveToEx (hdcMem, upper_marker, bottom_offset+370, NULL);
    LineTo   (hdcMem, upper_marker, bottom_offset+460 );
   
  SelectObject (hdcMem, hOldPen);
  DeleteObject (hPen);
 




//************************************************************************************        
// "Blit" the finished drawing to the physical screen:
//************************************************************************************
         
  BitBlt(((LPPAINTSTRUCT)(&ps))->hdc,
		 0,0,
         rctClientArea.right, rctClientArea.bottom,
         hdcMem,
         0, 0,
         SRCCOPY);         

  // Done with off-screen bitmap and DC, get rid of them




  SelectObject (hdcMem, hbmOld);
  DeleteObject (hbmMem);
  DeleteDC (hdcMem);
  DeleteDC (hDC);

       
  EndPaint(hWnd, &ps);


  return 0L;          // WM_PAINT message sucessfully handled
}










/*------------------------------------------------------------------------------
 *
 *      Show About box
 */

void vShowAboutBox (HWND hwnd)
{

  MessageBox (hwnd,
			  "FSQCALL, a keyboard text mode using\n"
              "Incremental Frequency shift Keying (IFK),\n" 
              "with image and file transfer and retrieval,\n"
              "and other potentially useful features\n"
              "(see help files for more details).\n\n"                 
        	  "This version 21 October 2016\n"
              "Written by Con Wassilieff ZL2AFP\n"
		      "with assistance from Murray Greenman ZL1BPU\n\n"
              "DO NOT USE for mission-critical applications!\n"
              "No performance promises are made or implied,\n"
              "and no responsibility will be accepted for misuse\n"
              "or failure of software to perform.\n\n" 
            
              "Use at own risk!\n"

		     
            ,
              "FSQCALL v0.41", 0);
	
}



/*------------------------------------------------------------------------------
 *
 *      Windows message callback handler
 *
 *      (This function is called by the Windows function's DispatchMessage() )
 */


LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{


  static HBRUSH hBrush;  //MUST be static!
  static HBRUSH hBrushButton, hBrushButtonAlt, hBrushBorder;
  static HBRUSH hBrush_receive, hBrush_send;
  static HCURSOR hCursor, hCursorArrow;



//Serial comms setup parameters
  FILE *setupfile;
  FILE *filelist;
  DCB dcbSerialParams   = {0};
  COMMTIMEOUTS timeouts = {0};

 
       
  int comport_default       = 1;    //default comport (no longer used)
  int baudrate_default      = 9600; //default baudrate for serial comms
  int stopbits_default      = 1;
  int bitsperbyte_default   = 8;
  int rig_index_default     = 0; 
  int camera_number_default = 0;    //default webcam, if there is one
  int screenX				= 0;
  int screenY				= 0;
  int screenW				= 943;  //default values
  int screenH				= 575;

  char dummy[80];
  int index;
  char FileName[80];  //For opening a new setup file later on


  switch (message)
  {
    case WM_CREATE:


//Prime the SELCAL FIFO buffer with junk to avoid a crash
	
			for( i=0;i<23;i++)
				input_text[i] = 40;
     

//Prime the incoming message buffer with nulls (32000 of them)
             int n = 0;         
			 for (n=0;n<32000;n++)Message_buffer[n]='\0'; 

//Create a dummy MSG_RX file so that pressing MSG_RX button does not result in unpredictable behaviour using ShellExecute
          sprintf(new_filename,"%s.txt","[000]");	

        
//get the initial path to ensure the setup file is not saved in the current directory elsewhere (after getting a file from another folder)
char szDir[MAX_PATH] = "";
GetFullPathName( "FSQCALv041.exe", // file name
sizeof(szDir),                     // size of path buffer
szDir,                             // path buffer
NULL                               // address of file name in path
);

strncpy(fullpath,szDir,strlen(szDir)-14);
strcat(fullpath,"FSQCALv041_setup.txt");

strncpy(fullHeardLogpath,szDir,strlen(szDir)-14);    //Note: strlen("FSQCALv041.exe") = 14
strcat(fullHeardLogpath,"Heardlog.txt");

//Create folder for incoming files for the # and + commands
strncpy(full_incoming_path,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  //Note: strlen("FSQCALv041.exe") = 14
strcat(full_incoming_path,"Shared");
CreateDirectory (full_incoming_path, NULL); 

//Create subfolder for storing images
strncpy(full_image_path,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_image_path,"Shared/Images");
CreateDirectory (full_image_path, NULL); 

//Create secure path to point to Files.bat, in case a file is stored elsewhere and messes up ShellExecute
strncpy(full_path_Filesbat,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_Filesbat,"\Files.bat");
		
//Create secure path to point to FSQhelp.htm
strncpy(full_path_FSQhelp,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_FSQhelp,"Help/FSQhelp.htm");

//Create secure path to point to CALLhelp.htm
strncpy(full_path_CALLhelp,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_CALLhelp,"Help/CALLhelp.htm");

//Create secure path to point to Tour.htm
strncpy(full_path_TOURhelp,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_TOURhelp,"Help/Tour.htm");

//Create secure path to point to Telemetry.htm
strncpy(full_path_TELEMETRYhelp,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_TELEMETRYhelp,"Help/Telemhelp.htm");

//Create secure path to point to IMAGEhelp.htm
strncpy(full_path_IMAGEhelp,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_IMAGEhelp,"Help/IMAGEhelp.htm");

//Create secure path to point to FSQplot.exe
strncpy(full_path_FSQplot,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_FSQplot,"\FSQplot.exe");

//Create secure path to point to Syntax.htm
strncpy(full_path_SYNTAXhelp,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_SYNTAXhelp,"Help/Syntax.htm");

//Create secure path to point to Rules.htm
strncpy(full_path_RULEShelp,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_RULEShelp,"Help/Rules.htm");

//Create secure path to point to the telemetry pickup file, Data.txt
strncpy(full_path_Data_txt,szDir,strlen(szDir)-strlen("FSQCALv041.exe"));  
strcat(full_path_Data_txt,"Shared/Data.txt"); 


 if ((setupfile = fopen("FSQCALv041_setup.txt", "r")) == NULL)
		{
         setupfile = fopen("FSQCALv041_setup.txt", "w");

         fprintf(setupfile, "%s\n", "COM0");//comport_default);
         fprintf(setupfile, "%d\n", baudrate_default);
         fprintf(setupfile, "%s\n", "N");//parity_default
         fprintf(setupfile, "%d\n", bitsperbyte_default);
         fprintf(setupfile, "%d\n", stopbits_default);

         fprintf(setupfile, "%d\n", rig_index_default);
         fprintf(setupfile, "%d\n", 30);  //brightness default

         fprintf(setupfile, "%s\n", "nocall");
 
		 fprintf(setupfile, "%d\n", 0);
         fprintf(setupfile, "%d\n", 0);

         fprintf(setupfile, "%s\n", "CQ CQ CQ de nocall");
         fprintf(setupfile, "%s\n", "noplace");

         fprintf(setupfile, "%s\n", "FEFE76E01C0001FD");   //CAT commands default in text format (put in quotes)
         fprintf(setupfile, "%s\n", "FEFE76E01C0000FD");

//         fprintf(setupfile, "%d\n", camera_number_default);

         fprintf(setupfile, "%d\n",screenX);
         fprintf(setupfile, "%d\n",screenY);
         fprintf(setupfile, "%d\n",screenW);
         fprintf(setupfile, "%d\n",screenH);
 
		 fprintf(setupfile, "%s\n\n\n\n", "");

         fprintf(setupfile, "Description of parameters above - "
                            "\n-comport"
			                "\n-baudrate"
			                "\n-parity"
			                "\n-bits"
			                "\n-stopbits"
				            "\n-Rig list index"
			             	"\n-Waterfall brightness setting"
			                "\n-callsign"
			                "\n-soundcard in"
			                "\n-soundcard out"
			                "\n-CQ or other message text"
				            "\n-Station location (qth etc)"
							"\n-CAT command for TX if not in dropdown list"
			                "\n-CAT command for RX if not in dropdown list"
				            "\n\n (note: These can be text or hexadecimal values" 
				            "\n        -see your radio manual for the commands"
				            "\n         The default eaxmple above is for the ICOM7200,"
                            "\n         but many rigs use text such as TX; and RX;"
			                "\n         You may also have to edit the baudrate and stopbits)"
				            "\n\n-Main window coordinates, x, y, width, and height");
         fclose(setupfile);
 
        } 
 fclose(setupfile);

  if ((setupfile = fopen("FSQCALv041_setup.txt", "r")) == NULL)    // Load comport and other details
	 {
       comports[0]    = 'COM0';
	   baudrate       = 9600;
       stopbits       = 1;
       bitsperbyte    = 8;
	   parity[0]      = 'N';

     }
	else
     {
      setupfile = fopen("FSQCALv041_setup.txt", "r");    //this MUST be in here!

         fgets(comports,        80,setupfile);
         fgets(baud,            80,setupfile);
         fgets(parity,          80,setupfile);
         fgets(bitsperbyte_s,   80,setupfile);
         fgets(stopbit_s,       80,setupfile);

         fgets(rig_index_s,     80,setupfile);
         fgets(bright_s,        80,setupfile);
 
         fgets(callsign,        80,setupfile);
		 fgets(soundcard_in_s,  80,setupfile);
         fgets(soundcard_out_s, 80,setupfile);

         fgets(cq_text,         256,setupfile);
         fgets(location,        256,setupfile);

         fgets(CAT_tx_file_command,  80,setupfile);
	     fgets(CAT_rx_file_command,  80,setupfile);

         fgets(screenX_s,       80,setupfile);
         fgets(screenY_s,       80,setupfile);
         fgets(screenW_s,       80,setupfile);
         fgets(screenH_s,       80,setupfile);

       fclose(setupfile);  

    //   comport          = atoi(comports);  //convert character into integer
	   baudrate         = atoi(baud);
       stopbits         = atoi(stopbit_s);
       bitsperbyte      = atoi(bitsperbyte_s);
       rig_index        = atoi(rig_index_s);
       bright           = atoi(bright_s);
       soundcard_in_ID  = atoi(soundcard_in_s);
	   soundcard_out_ID = atoi(soundcard_out_s);
       screenX          = atoi(screenX_s);
       screenY          = atoi(screenY_s);
       screenW          = atoi(screenW_s);
       screenH          = atoi(screenH_s);
	
//For some reason CRLF's are added to some text strings. Remove them!
       remove_char_from_string(0xA, comports);  //CR
       remove_char_from_string(0xD, comports);  //LF

       remove_char_from_string(0xA, callsign);  //CR
       remove_char_from_string(0xD, callsign);  //LF

       remove_char_from_string(0xA, cq_text);  //CR
       remove_char_from_string(0xD, cq_text);  //LF

       remove_char_from_string(0xA, location);  //CR
       remove_char_from_string(0xD, location);  //LF

       remove_char_from_string(0xA, CAT_tx_file_command);  //CR
       remove_char_from_string(0xD, CAT_tx_file_command);  //LF

       remove_char_from_string(0xA, CAT_rx_file_command);  //CR
       remove_char_from_string(0xD, CAT_rx_file_command);  //LF

     }


//==========================================================================================================================
//Create the index files to list all files in the "Shared" and "Images" folder
//The DOS version of v0.36 requires pathnames to have no spaces, which could be restrictive to some users

strcpy(FilesShortindexpath,full_incoming_path);
strcpy(FilesLongindexpath,full_incoming_path);  
strcpy(Imageindexpath,full_incoming_path);

strcat(FilesShortindexpath,"\\Short.");
strcat(FilesLongindexpath,"\\Long.");
strcat(Imageindexpath,"\\Images.");

if(strstr(callsign,"nocall")!=0)goto skip_nocall;
strcat(FilesShortindexpath,callsign);
strcat(FilesLongindexpath,callsign);
strcat(Imageindexpath,callsign);

ListShortDirectoryContents(full_incoming_path, FilesShortindexpath);
ListLongDirectoryContents(full_incoming_path, FilesLongindexpath);
ListShortDirectoryContents(full_image_path, Imageindexpath);

//Set up a path to the "*.nocall" files for later deletion when callsign is changed
/*
					strcpy(NocallShortpath,full_incoming_path);
					strcat(NocallShortpath,"\\Short.nocall");				
				
					strcpy(NocallLongpath,full_incoming_path);
					strcat(NocallLongpath,"\\Long.nocall");				
			
					strcpy(NocallImagespath,full_incoming_path);  //only this one works!
					strcat(NocallImagespath,"\\Images.nocall");
*/	
			
skip_nocall:							

//===========================================================================================================

		
    squelch_level= 425;  //default squelch level
    peak_hits    = 3;    //default "peaks hit parade" count   
         


  
         
    hCursor      =    LoadCursor(hThisInstance,IDC_SIZEWE );
    hCursorArrow =    LoadCursor(hThisInstance,IDC_ARROW);

    hBrush = CreateSolidBrush ( RGB(64, 64, 64) );           //a brush to colour the trackbars dark gray to match the background

    hBrush_receive = CreateSolidBrush ( RGB(250,230,160) );  //colour the receive screen yellow-ish
    hBrush_send    = CreateSolidBrush ( 0xE1E4FF );    //colour the send screen blue-ish
    hBrush_listbox  = CreateSolidBrush ( 0xE1E4FF );    //colour the send screen blue-ish

//Create an owner drawn button and colours for same
        hBrushButton = CreateSolidBrush (0x00504000); 
        hBrushButtonAlt = CreateSolidBrush (0x00B09000);
        hBrushBorder =  CreateSolidBrush (0x00F0C080);
    
    	


// *********************** Textbox for received text ************************************************************

//int hFont = (int)GetStockObject(ANSI_VAR_FONT);

  HFONT   RXfont=CreateFont(16,6,0,0,700,FALSE,FALSE,FALSE,DEFAULT_CHARSET,OUT_OUTLINE_PRECIS,
                    CLIP_DEFAULT_PRECIS,PROOF_QUALITY, VARIABLE_PITCH,TEXT("Arial")); //Arial Bold 10 point

  LoadLibrary("Riched32.dll");

  hCtl = CreateWindowEx(0,
               "Richedit", "", 
              WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_TABSTOP | ES_MULTILINE | ES_AUTOVSCROLL |WS_VSCROLL | WS_BORDER, 
               0, 0, 823, 289,
               hwnd, NULL, GetModuleHandle(""),  NULL);

  SendMessage (hCtl, WM_SETFONT,  (WPARAM) RXfont, MAKELPARAM(TRUE, 0));   
 // SendMessage (hCtl, EM_LIMITTEXT, 0, 0L);

  SendMessage (hCtl, EM_SETBKGNDCOLOR, 0,  0xCDFAFF) ;

 // SendMessage(hCtl, EM_SETEVENTMASK, (WPARAM)0, (LPARAM)ENM_MOUSEEVENTS); //So we can capture mouse click on RX screen
//  hEditDC = GetDC(hCtl);
/*
//****************** Textbox for sending text ***************************************************************
 hCtl_TX = CreateWindowEx(0,
               "edit", "", 
              WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_TABSTOP | ES_MULTILINE | ES_AUTOVSCROLL |WS_VSCROLL, 
               0, 290, 825, 70,
               hwnd, NULL, GetModuleHandle(""),  NULL);

  SetFocus(hCtl_TX);  //Make sure the cursor/caret is in the send textbox on startup	

*/
int offset=82;  //This now has no effect as it is all done in the WM_SIZE routine

//Create Send button =================================================
        
   g_hwndTXbutton = CreateWindowEx ( 
        0,                                    // no extended styles 
        "static",                             // class name 
        "Pass",                               // title (caption) 
        WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,// style
        716+offset, 490,                         // position 
        110, 20,                              // size 
        hwnd,                                 // parent window 
        (HMENU) IDC_TX_BUTTON,                // control identifier 
        GetModuleHandle(NULL),                // instance 
        NULL                                  // no WM_CREATE parameter 
        ); 

hBitmapTX_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_TX_OFF"); 
hBitmapTX_ON = LoadBitmap(g_hInst, "IMG_BITMAP_TX_ON");  
// Set the button image 
SendMessage(g_hwndTXbutton,STM_SETIMAGE, 0,(LPARAM) hBitmapTX_OFF); //Set default button to USB
     
        
        
//Create Receive button===============================================      
   g_hwndRXbutton = CreateWindowEx ( 
        0,                                   // no extended styles 
        "static",                            // class name 
        "RX",                                // title (caption) 
         WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,
        776+offset, 490,                        // position 
        60, 20,                             // size 
        hwnd,                                // parent window 
        (HMENU) IDC_RX_BUTTON,               // control identifier 
        GetModuleHandle(NULL),               // instance 
        NULL                                 // no WM_CREATE parameter 
        ); 

hBitmapRX_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_RX_OFF");
hBitmapRX_ON = LoadBitmap(g_hInst, "IMG_BITMAP_RX_ON");  
// Set the button image
SendMessage(g_hwndRXbutton,STM_SETIMAGE, 0,(LPARAM) hBitmapRX_ON);  


//Create Pause button==================================================      
   g_hwndPausebutton = CreateWindowEx ( 
        0,                                 // no extended styles 
        "static",                          // class name 
        "Pause",                           // title (caption) 
        WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,
        655+offset, 490,                      // position 
        110, 20,                           // size 
        hwnd,                              // parent window 
        (HMENU) IDC_PAUSE_BUTTON,          // control identifier 
        GetModuleHandle(NULL),             // instance 
        NULL                               // no WM_CREATE parameter 
        ); 

hBitmapPause_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_PAUSE_OFF");
hBitmapPause_ON = LoadBitmap(g_hInst, "IMG_BITMAP_PAUSE_ON");  
// Set the button image 
SendMessage(g_hwndPausebutton,STM_SETIMAGE, 0,(LPARAM) hBitmapPause_OFF);  


//Create "QTC" button==================================================      
   g_hwndCQbutton = CreateWindowEx ( 
        0,                                 // no extended styles 
        "static",//"button",                          // class name 
        "QTC",                           // title (caption) 
        WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,//WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON | BS_CENTER | SS_NOTIFY,
        294+offset, 490,                      // position 
        110, 20,                           // size 
        hwnd,                              // parent window 
        (HMENU) IDC_QTC_BUTTON,          // control identifier
        GetModuleHandle(NULL),             // instance 
        NULL                               // no WM_CREATE parameter 
        ); 

hBitmapQTC_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_QTC_OFF");
hBitmapQTC_ON = LoadBitmap(g_hInst, "IMG_BITMAP_QTC_ON");  
// Set the button image 
SendMessage(g_hwndCQbutton,STM_SETIMAGE, 0,(LPARAM) hBitmapQTC_OFF); 
 
    SetWindowContextHelpId(g_hwndCQbutton, IDC_QTC_BUTTON ); 

//Create "QTH" button==================================================      
   g_hwndQTHbutton = CreateWindowEx ( 
        0,                                 // no extended styles 
        "static",//"button",                          // class name 
        "QTH",                           // title (caption) 
        WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,//WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON | BS_CENTER | SS_NOTIFY,
        353+offset, 490,                      // position 
        110, 20,                           // size 
        hwnd,                              // parent window 
        (HMENU) IDC_QTH_BUTTON,                 // control identifier
        GetModuleHandle(NULL),             // instance 
        NULL                               // no WM_CREATE parameter 
        ); 

hBitmapQTH_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_QTH_OFF");
hBitmapQTH_ON = LoadBitmap(g_hInst, "IMG_BITMAP_QTH_ON");  
// Set the button image
SendMessage(g_hwndQTHbutton ,STM_SETIMAGE, 0,(LPARAM) hBitmapQTH_OFF);

    SetWindowContextHelpId(g_hwndQTHbutton, IDC_QTH_BUTTON ); 

                   //Create "SELCAL" button==================================================    Created these buttons only when FSQCAL is ON  
                          g_hwndFSQCALbutton = CreateWindowEx ( 
                               0,                                 // no extended styles 
                               "static",                          // class name 
                               "FSQCAL",                           // title (caption) 
                               WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,
                               412+offset, 490,                      // position 
                               60, 21,                           // size 
                               hwnd,                              // parent window 
                               (HMENU) IDC_FSQCAL_BUTTON,          // control identifier 
                               GetModuleHandle(NULL),             // instance 
                               NULL                               // no WM_CREATE parameter 
                               ); 

                           hBitmapSELCAL_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_SELCAL_OFF");
                           hBitmapSELCAL_ON = LoadBitmap(g_hInst, "IMG_BITMAP_SELCAL_ON"); 
                           hBitmapSELCAL_GREEN = LoadBitmap(g_hInst, "IMG_BITMAP_SELCAL_GREEN");  
                         /* Set the button image*/ 
                           SendMessage(g_hwndFSQCALbutton,STM_SETIMAGE, 0,(LPARAM) hBitmapSELCAL_ON);  


                    //Create "SAVE" button==================================================      
                           g_hwndSAVEbutton = CreateWindowEx ( 
                                0,                                 // no extended styles 
                                "static",                          // class name 
                                "SAVE",                           // title (caption) 
                                WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,
                                472+offset, 490,                      // position 
                                60, 21,                           // size 
                                hwnd,                              // parent window 
                                (HMENU) IDC_SAVE_BUTTON,          // control identifier 
                                GetModuleHandle(NULL),             // instance 
                                NULL                               // no WM_CREATE parameter 
                                ); 

                            hBitmapSAVE_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_SAVE_OFF");
                            hBitmapSAVE_ON  = LoadBitmap(g_hInst, "IMG_BITMAP_SAVE_ON");  
                          /* Set the button image*/ 
                            SendMessage(g_hwndSAVEbutton,STM_SETIMAGE, 0,(LPARAM) hBitmapSAVE_OFF);  

                    //Create "Sounding" button==================================================      
                           g_hwndSOUNDINGbutton = CreateWindowEx ( 
                                0,                                 // no extended styles 
                                "static",                          // class name 
                                "SOUND",                           // title (caption) 
                                WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,
                                534+offset, 490,                      // position 
                                60, 21,                           // size 
                                hwnd,                              // parent window 
                                (HMENU) IDC_SOUNDING_BUTTON,          // control identifier 
                                GetModuleHandle(NULL),             // instance 
                                NULL                               // no WM_CREATE parameter 
                                ); 

                            hBitmapSOUNDING_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_SOUND_OFF");
							hBitmapSOUNDING_ON  = LoadBitmap(g_hInst, "IMG_BITMAP_SOUND_ON");  
                          /* Set the button image*/ 
                            SendMessage(g_hwndSOUNDINGbutton,STM_SETIMAGE, 0,(LPARAM) hBitmapSOUNDING_OFF);  


                    //Create "MSG_RX" button==================================================      
                           g_hwndMSGRXbutton = CreateWindowEx ( 
                                0,                                 // no extended styles 
                                "static",                          // class name 
                                "MSG_RX",                           // title (caption) 
                                WS_CHILD | WS_VISIBLE | SS_BITMAP | SS_NOTIFY,
                                595+offset, 490,                      // position 
                                60, 21,                           // size 
                                hwnd,                              // parent window 
                                (HMENU) IDC_MSGRX_BUTTON,          // control identifier 
                                GetModuleHandle(NULL),             // instance 
                                NULL                               // no WM_CREATE parameter 
                                ); 

                            hBitmapMSGRX_OFF = LoadBitmap(g_hInst, "IMG_BITMAP_MSGRX_OFF");
                            hBitmapMSGRX_ON  = LoadBitmap(g_hInst, "IMG_BITMAP_MSGRX_ON");  
                          /* Set the button image*/ 
                            SendMessage(g_hwndMSGRXbutton,STM_SETIMAGE, 0,(LPARAM) hBitmapMSGRX_OFF); 

//Waterfall display brightness treackbar================================
 
    hwndTrack_brightness = CreateWindowEx ( 
        0,                                  // no extended styles 
        "MSCTLS_TRACKBAR32",                // class name 
        "Trackbar Control",                 // title (caption) 
        WS_CHILD | WS_VISIBLE | TBS_NOTICKS  | TBS_BOTH | TBS_HORZ,// style
        10, 492,                            // position 
        80, 20,                            // size 
        hwnd,                               // parent window 
        NULL,                               // control identifier (don't need it subsequently so make it NULL
        hThisInstance,                      // instance 
        NULL                                // no WM_CREATE parameter 
        ); 
  
    SendMessage(hwndTrack_brightness, TBM_SETRANGE, 
        (WPARAM) TRUE,                      // redraw flag 
        (LPARAM) MAKELONG(0, 100));         // min. & max. positions 
    SendMessage(hwndTrack_brightness, TBM_SETPAGESIZE, 
        0, (LPARAM) 1);                    // new page size 

    SendMessage(hwndTrack_brightness, TBM_SETPOS, 
        (WPARAM) TRUE,                      // redraw flag 
        (LPARAM) bright);                       // set initial brightness level
 
    bright = SendMessage(hwndTrack_brightness, TBM_GETPOS, 0,0); //get the trackbar position 

 




                         Tabfont=CreateFont(16,6,0,0,700,FALSE,FALSE,FALSE,DEFAULT_CHARSET,OUT_OUTLINE_PRECIS,
                                         CLIP_DEFAULT_PRECIS,PROOF_QUALITY, VARIABLE_PITCH,TEXT("Calibri")); 

                        
	                     hBrushTab = CreateSolidBrush ( RGB(255, 255, 255) );  //Makes RX tab have white b/g and the trackbars transparent

                //****************** Textbox for monitoring FSQCAL all incoming text **************************************************
                          hwndMonitor = CreateWindowEx(0,
                               "Richedit", "", 
                               WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_TABSTOP | ES_MULTILINE | ES_AUTOVSCROLL |WS_VSCROLL ,//| WS_BORDER, 
                                370,290,453+103,212-16,
                               hwnd, NULL, GetModuleHandle(""),  NULL);
                         SendMessage (hwndMonitor, WM_SETFONT,  (WPARAM) Tabfont, MAKELPARAM(TRUE, 0));
                         SendMessage (hwndMonitor, EM_SETBKGNDCOLOR, 0,  0xDDFAFF) ; 



	               //************************** Create a Listbox for the "heard" callsigns list*****************************************************

                          Listfont = CreateFont(16,6,0,0,400,FALSE,FALSE,FALSE,DEFAULT_CHARSET,OUT_OUTLINE_PRECIS,
                                                      CLIP_DEFAULT_PRECIS,PROOF_QUALITY, VARIABLE_PITCH,TEXT("Calibri")); 

                          hwndList = CreateWindowEx (0, "listbox", "",
                                                     WS_CHILD | WS_VISIBLE  | LBS_NOTIFY ,// | LBS_STANDARD,
                                                     370+453,0,103,300-10,
                                                     hwnd, (HMENU) ID_LIST, g_hInst,  NULL);

                          SendMessage (hwndList, WM_SETFONT,  (WPARAM) Listfont, MAKELPARAM(TRUE, 0)); 
                          SendMessage (hwndList, LB_SETITEMHEIGHT, 0,  0) ; 
						  SendMessage (hwndList, LB_ADDSTRING, 0, (LPARAM)"allcall");   //Add "allcall" to the list to allow it to be pasted into the send box 
                          SendMessage (hwndList, LB_SETHORIZONTALEXTENT, 103, 0);

	               //************************** Create a blank box to putat the end of the Listbox to cover up the flickering dark bits**************

                          hwndBlank = CreateWindowEx (0, "static", "",
                                                     WS_CHILD | WS_VISIBLE | SS_WHITERECT,// | LBS_STANDARD,
                                                     370+453,275,103,15,
                                                     hwnd, NULL, g_hInst,  NULL);



                    //**************************Create a Textbox for sending text ***************************************************************
                          hCtl_TX = CreateWindowEx(0,
                                                   "edit", "", 
                                                    WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_TABSTOP | ES_MULTILINE | ES_AUTOVSCROLL |WS_VSCROLL 	, 
                                                    0, 290, 369, 70,  //shrunk to allow for the listbox window
                                                    hwnd, NULL, GetModuleHandle(""),  NULL);

                          SetFocus(hCtl_TX);  //Make sure the cursor/caret is in the send textbox on startup
	
                   //**************** Subclass the send edit box to trap the ENTER and ESC keys **********************
                          DefEditProc = (WNDPROC)GetWindowLong(hCtl_TX,GWL_WNDPROC);
                          SetWindowLong(hCtl_TX,GWL_WNDPROC,(long)MyEditProc); 
			




//Waterfall display setup================================================
 
       hdc2 = GetDC(HWND_DESKTOP);   //Get a DC from somewhere for the waterfall display
 
       hdcScroll = CreateCompatibleDC (hdc2);
  
  // Create an off-screen bitmap to do the off-screen drawing on waterfall display:
  
       hbmScroll = CreateCompatibleBitmap (hdc2, 640+350, 1200); 
  // Direct waterfall drawing operations onto the off-screen bitmap:

       hbmScrollOld = (HBITMAP) SelectObject (hdcScroll, hbmScroll);

//===================================================
//=================POPUP MENUS=======================
//===================================================  
// Load the popup menu for the receive Richedit screen

          hPopMenu = LoadMenu (g_hInst, "POPMENU") ;
          hPopMenu = GetSubMenu (hPopMenu, 0) ;

//and for the Monitor screen

          hPopMenuMonitor = LoadMenu (g_hInst, "POPMENUMONITOR") ;
          hPopMenuMonitor = GetSubMenu (hPopMenuMonitor, 0) ;
     
//A popup menu for the Commands

          hPopMenuCommands = LoadMenu (g_hInst, "POPMENUCOMMANDS") ;
          hPopMenuCommands = GetSubMenu (hPopMenuCommands, 0) ;

	HBITMAP hBmp = LoadBitmap(g_hInst,"QUERY");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_QUERY, MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"HEARD");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_HEARD, MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"@");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_LOCATION, MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"STATION_MESSAGE");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_STATION_MSG , MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"SOFTWARE_VERSION");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_VERSION , MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"SQUELCH");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_SQUELCH , MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"SLOW_DOWN");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_SLOW_DOWN, MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"SPEED_UP");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_SPEED_UP, MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"PUT_FILE");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_PUT_FILE , MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"GET_FILE");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_GET_FILE , MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"SEND_ALERT");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_SEND_ALERT , MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"RELAY");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_RELAY, MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"RELAY_LATER");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_RELAY_LATER , MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"SEND_IMAGE");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_SEND_IMAGE , MF_BYCOMMAND, hBmp, hBmp);
	hBmp = LoadBitmap(g_hInst,"ACTIVE");
    SetMenuItemBitmaps(hPopMenuCommands, IDM_ACTIVE, MF_BYCOMMAND, hBmp, hBmp);


//===================================================
//=================TOOLTIPS==========================
//===================================================  

//Create a tooltip to let users know to right click the mouse over the Heard list to bring up the Commands menu
	CreateToolTip(ID_LIST, hwnd, "Left click select callsign\n\nRight click to select command");

//Create tooltips to for the other controls
	CreateToolTip(IDC_RX_BUTTON, hwnd, "Starts receiver (stops transmitter)");
	CreateToolTip(IDC_TX_BUTTON, hwnd, "Starts transmitter");
	CreateToolTip(IDC_PAUSE_BUTTON, hwnd, "Stops receiver or transmitter");
	CreateToolTip(IDC_MSGRX_BUTTON, hwnd, "Message available when red\n - Click to read message (when red)\n - Click to see working folder (when dark)");
	CreateToolTip(IDC_SOUNDING_BUTTON, hwnd, "Click to start periodic Sounding");
	CreateToolTip(IDC_SAVE_BUTTON, hwnd, "EMERGENCY SAVE for encoded files only\n\nSave raw samples to 'emergency.enc.RS' file  if SELCAL button does not turn green or if part of the header is corrupted.");
	CreateToolTip(IDC_FSQCAL_BUTTON, hwnd, "Click to enable/disable Active mode\n  - Light blue when Active\n  - Green when incoming traffic");
	CreateToolTip(IDC_QTH_BUTTON, hwnd,"Left click to send location message\n - Right click to edit message");
	CreateToolTip(IDC_QTC_BUTTON, hwnd, "Left click to send pre-defined message\n - Right click to edit message");



 // Initialize PortAudio subsystem========================================

//  DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_SOUNDCARD), NULL, (DLGPROC)SOUNDCARDDlgProc); //select soundcard


      Start_Portaudio();                    //Start receiver
      Pa_StopStream (g_PAStream);           //temporarily stop receiver to avoid screen flicker 
                                            //when starting sender 

      Start_Portaudio_Send();               //Start sender
      Pa_StopStream (g_PAStream_Send);      //Stop sender until needed later

      Pa_StartStream (g_PAStream);          //Restart receiver
 
    
//Generate the CRC lookup table
      init_crc8();
  
  //Calculate the CRC on the callsign for use as a timer interval for the FSQCAL replies 
                             
       /*********************************
                 Do a CRC8 on the callsign
        **********************************/
          //   unsigned char crc;
		    			crc='\0';
             unsigned char ch;
             int i;
             for ( i=0;i<strlen(callsign);i++ )
              {
               ch = callsign[i];
               crc = crc8_table[(crc) ^ ch];
               crc &= 0xFF;
              }
       
		 //     sprintf(CRC,"%02x",crc);   //convert the character into two equivalent hex values
         //     SetWindowText(hwnd,CRC); 

   // Start a periodic timer that posts a WM_TIMER message each 10 minutes for timestamp of received stuff
       SetTimer (hwnd, 0, 970, NULL);        //run timer every 0.97 seconds to make sure we catch the 00 second exactly on the minute.   

   // Timer to update the display every 0.02 seconds

       SetTimer (hwnd, 3, 50, NULL);

   // Timer to check for existence of file Data.txt every 5 seconds

       SetTimer (hwnd, 5, 5000, NULL);


	// Bring up the PTT/CAT dialog box before main program starts (easiest way to start the PTT/CAT)
	  DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_PTT), NULL, (DLGPROC)PTTDlgProc);
      Use_file_commands(); //check to see if we are using the CAT commands from the setup file

    //Print callsign on the program banner
	  char banner[64];
      sprintf(banner,"%s  %s",software_version,callsign);
      SetWindowText(hwnd,banner);


      MoveWindow (hwnd, screenX, screenY, screenW, screenH, TRUE);   //use this to remember main window coordinates after closing program


      break;



 case WM_SIZE:
			{
             RECT rc;

			 GetClientRect (hwnd, &rc);

             Voffset = rc.bottom - 518;
			 Hoffset = rc.right  - 927;
			
			 MoveWindow (g_hwndRXbutton,       Hoffset+858, Voffset+490, 58, 24, TRUE);
 			 MoveWindow (g_hwndTXbutton,       Hoffset+798, Voffset+490, 58, 24, TRUE);
			 MoveWindow (g_hwndPausebutton,    Hoffset+737, Voffset+490, 58, 24, TRUE);  
			 MoveWindow (g_hwndMSGRXbutton,    Hoffset+677, Voffset+490, 58, 24, TRUE);
			 MoveWindow (g_hwndSOUNDINGbutton, Hoffset+616, Voffset+490, 58, 24, TRUE);
			 MoveWindow (g_hwndSAVEbutton,     Hoffset+555, Voffset+490, 58, 24, TRUE);
			 MoveWindow (g_hwndFSQCALbutton,   Hoffset+494, Voffset+490, 58, 24, TRUE);
			 MoveWindow (g_hwndQTHbutton,      Hoffset+435, Voffset+490, 58, 24, TRUE);
			 MoveWindow (g_hwndCQbutton,       Hoffset+376, Voffset+490, 58, 24, TRUE);

			 MoveWindow (hwndTrack_brightness, 10,  Voffset+492, 80, 20, TRUE);

			 MoveWindow (hwndList,             Hoffset+823,  0,   103,           Voffset/2+288, TRUE);//resizes vertically in units of lines not pixels
			 MoveWindow (hCtl,                 0,    0,           Hoffset+823,   Voffset/2+290, TRUE); 
			 MoveWindow (hCtl_TX,              0,    Voffset/2+290, 369,         Voffset/2+ 70, TRUE);
			 MoveWindow (hwndMonitor,          370,  Voffset/2+290, Hoffset+556, Voffset/2+196, TRUE);

             MoveWindow (hwndBlank,            Hoffset+823,  Voffset/2+273, 103, 16, TRUE); //covers up the dark bits at the end of the listbox

			 SendMessage (hCtl, EM_SCROLL, SB_PAGEDOWN, 0);        //We need this to make sure the text is printed in the correct position 
			 SendMessage (hwndMonitor, EM_SCROLL, SB_PAGEDOWN, 0); //after the program is minimized 
            }

	break;

 


 case WM_TIMER:
 
       switch (wParam)
       {
				FILE	*datafile;
				char	*data_filename;
//This palaver is for the grey timestamp message
          case 0:
           {
           int crlf = 10;                          //CRLF to put in front of and behind timestamp message

           SYSTEMTIME current_time;
           char timebuffer[256]; 
           GetLocalTime(&current_time);            //what it says

           if(Timestamp == FALSE)break;            // if timestamp is off, then don't print timestamp

           if(((current_time.wMinute % 10) == 0) & (current_time.wSecond == 0))
              {
               sprintf(timebuffer, "[Local time %02d:%02d]\n", current_time.wHour, current_time.wMinute);
   		
               int text_length = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
               SendMessage(hCtl, EM_SETSEL, text_length, text_length);                           
               SendMessage(hCtl, EM_REPLACESEL, 0, (LPARAM)&crlf);          //Add the CRLF 
               text_length = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
               SendMessage(hCtl, EM_SETSEL, text_length, text_length);

                cf.cbSize      = sizeof(cf);       
                cf.dwMask      = CFM_COLOR;         //Set mask to colors only
              if(Text_colour == TRUE)
		         {
                  cf.crTextColor = RGB(128,128,128);      //Set the new colour value 
                 }
              else
                 {
                  cf.crTextColor = RGB(0,0,0);      //Set the colour back to black 
                 }  
               SendMessage(hCtl, EM_SETCHARFORMAT, SCF_SELECTION,(LPARAM) &cf);  //get the new colour
 
               SendMessage (hCtl, EM_REPLACESEL,  0, (LPARAM)&timebuffer);  //add timestamp to the received text
               SendMessage (hCtl, EM_SCROLLCARET, 0, 0 ); 
	           SendMessage (hwnd, WM_MOUSEMOVE,   0, 0);

              }
           else
              {
               break;
              } 
           }
            return 0;



//This bit attempts to send a return message every second, until the squelch is clear, then it sends it and stops the timer
        case 1:

           {
            if(signoise > squelch_level)                      //back-to-front because Windoze has the screen upside down!)    
               {                                              //only send when no one else is still sending ie. the green box < red line
               PostMessage(g_hwndTXbutton,WM_LBUTTONDOWN, 0, 0) ;
  		       KillTimer(hwnd,1);
  			   return 0;
		       }
		    else
               {
                if(counter++ == Reply_retries)                                                   //10 attempt watchdog "timer"
					{
                     counter = 0;                                                     //if timeout exceeds 10 attempts, reset counter 
					 KillTimer(hwnd,1);                                               //and reset timer

                     SetFocus(hCtl_TX);                                               //delete the message from the TX box
                     int text_length = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);  
               		 SendMessage (hCtl_TX, EM_SETSEL,      0, text_length);
                     SendMessage (hCtl_TX, EM_REPLACESEL,  0, (LPARAM)"");
					 SendMessage (hCtl_TX, EM_SCROLLCARET, 0, 0 );
                    } 
               } 
           }
			return 0;

//This bit sends a sounding message (ie own callsign:) periodically
        case 2:

           {
            if(signoise > squelch_level)                      //back-to-front because Windoze has the screen upside down!)    
               {                                              //only send when no one else is still sending ie. the green box < red line
                if(sounding_message_on == TRUE)
			      {						
                   int len;
                   len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" "); //add a space incase it is after the callsign
                   len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)sounding_message); //Send it all to the TX text box
                  }
                PostMessage(g_hwndTXbutton,WM_LBUTTONDOWN, 0, 0) ;
                SetFocus(hCtl_TX);  
  			    return 0;
		       }

           }           
			return 0;

//Update the display
         case 3:
               OnWmPaint (hwnd);

               InvalidateRect (hwnd,   // window handle
                      &graph_rect,     // redraw only the spectrum and waterfall area   // CONST RECT*, NULL => force redraw of entire client area
                      FALSE); 


               InvalidateRect (hwnd,  
                      &commands_rect,     // redraw the baudrate bar graph area
                      FALSE); 


            return 0;

//Timer to "flash" the QTC and QTH buttons for 100msec
          case 4:
                  KillTimer(hwnd,4);   
				  SendMessage(g_hwndCQbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapQTC_OFF);
                  SendMessage(g_hwndQTHbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapQTH_OFF);
				  return 0;

//Check for existence of file "Data.txt" for telemetry
		  case 5:

					if(FSQCAL_CREATE == FALSE) return 0;  
				//	data_filename = "Shared/Data.txt";
					char	command_line[255];
                    char	file_contents[32000];

					if(GetFileAttributes(full_path_Data_txt)!=-1) //is the file "Data.txt" there?
					{
						datafile = fopen(full_path_Data_txt, "r");//if so then read and send it
						fseek(datafile, 0, SEEK_END);
                   		long fsize = ftell(datafile);
				   		if(fsize>20000)fsize = 20000;   //limit the size of the text to be sent!
                   		fseek(datafile, 0, SEEK_SET);
                   		unsigned char file_contents[fsize];
				   		int i;
				   		for (i=0;i<fsize;i++)file_contents[i]='\0';    //Must flush the buffer
                   		fread(file_contents, fsize, 1, datafile);

                   		int length = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                  		length = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   		SendMessage(hCtl_TX, EM_REPLACESEL, length, (LPARAM)file_contents);  //Append file to the preamble

				   		fclose(datafile);
						remove(full_path_Data_txt);

						srand((int)clock());
						int starts = 500 + rand() % 3000;
						SetTimer(hwnd, 1, starts, NULL);    //Start a timer and then TX after squelch has closed  

					}
					else
					{
                     return 0;
					}
                                
				  return 0;

       }
	break;




 case WM_HSCROLL:

         
//waterfall brightness slider control     
     if (lParam == (int) hwndTrack_brightness)
     { 
        bright = SendMessage(hwndTrack_brightness, TBM_GETPOS, 0,0); //get the trackbar position              
        SetFocus (hCtl_TX);   //Put focus back to send box
     }       
      
    break;




 case WM_CTLCOLORSTATIC: 
		
  
      return (int) hBrush;   //don't need to use SetBkColor as hBrush does it all
            
 case WM_CTLCOLOREDIT: //this one also works for a trackbar

 {


// control's window handle is lParam, not hWnd
  if((HWND)lParam==hCtl)  // Receive screen graphics
   {
// HDC of control is wParam
         SetTextColor((HDC)wParam, RGB(0,0,120)); 
         SetBkColor((HDC)wParam,RGB(250,230,160)); 
         SetBkMode((HDC)wParam,OPAQUE);
        
// return new background brush
     return (int) hBrush_receive;
   }

  if((HWND)lParam==hCtl_TX)  // Send screen graphics
   {
// HDC of control is wParam
         SetBkMode((HDC)wParam,OPAQUE);
         SetTextColor((HDC)wParam, RGB(0,0,160));
         SetBkColor((HDC)wParam,0xE1E4FF);
// return new background brush
     return (int) hBrush_send;//(LRESULT)GetStockObject(WHITE_BRUSH);
   }
// just use the default settings otherwise
   return DefWindowProc(hwnd, message, wParam, lParam);
 }


 


//**************************************************************************************************************
//To enable an input box to pop up when QTC button is right-clicked (and QTH, and copy/paste for receive screen etc
//**************************************************************************************************************

  case WM_CONTEXTMENU:
       {
//bring up message text input box
        if(GetDlgCtrlID(g_hwndCQbutton) == GetWindowContextHelpId((HWND) wParam))
			{
			 DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_QTC), NULL, (DLGPROC)QTCmessageDlgProc); 
			 break;
            }

//bring up location text input box
        if(GetDlgCtrlID(g_hwndQTHbutton) == GetWindowContextHelpId((HWND) wParam)) 
			{
			 DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_QTH), NULL, (DLGPROC)QTHDlgProc);
			 break;
            }

//bring up copy/paste edit menu for receive screen

 if (wParam == (int) hCtl)  
			{
		     POINT point; 
             point.x = LOWORD (lParam) ;
             point.y = HIWORD (lParam) ;
          
             TrackPopupMenu (hPopMenu, TPM_LEFTALIGN, point.x, point.y, 0, hwnd, NULL) ;
			 break;				
            } 

//bring up copy/paste edit menu for monitor screen


  if (wParam == (int) hwndMonitor)   
			{
		     POINT point; 
             point.x = LOWORD (lParam) ;
             point.y = HIWORD (lParam) ;
          
             TrackPopupMenu (hPopMenuMonitor, TPM_LEFTALIGN, point.x, point.y, 0, hwnd, NULL) ;
			 break;				
            } 

//bring up Commands list when mouse click on Heard list


  if (wParam == (int) hwndList)   
			{
		     POINT point; 
             point.x = LOWORD (lParam) ;
             point.y = HIWORD (lParam) ;
          
             TrackPopupMenu (hPopMenuCommands, TPM_LEFTALIGN, point.x, point.y, 0, hwnd, NULL) ;
			 break;				
            } 

  		
       }
			return 0;

//*************************************************************************************************************************
//use F1 key to copy callsign from heard list to send box (this trick only works for F1 as WM_HELP is the F1 key command)
//*************************************************************************************************************************
 case WM_HELP: 
        { 
		   if(Sending_pic == TRUE)return 0;                               //prevent calling up the callsign via the F1 key
		   if(FSQCAL == TRUE) 
		    {
              int iIndex,  len;
              TCHAR   call[256];

              iIndex  = SendMessage (hwndList, LB_GETCURSEL, 0, 0) ;      //highlight the call     
              SendMessage (hwndList, LB_GETTEXT, iIndex, (LPARAM) call) ; //get the call from the listbox
              len = SendMessage (hwndList, LB_GETTEXTLEN, iIndex, 0) ;      //highlight the call   
			  if(len < 1)return 0;            
 
              SendMessage (hwndList, LB_GETTEXT, iIndex, (LPARAM) call) ; //get the call from the listbox           

              len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);  //get the length of the callsign in the send textbox
		      SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) call); //add it to the send box 
              SetFocus(hCtl_TX); 

              len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
              SendMessage(hCtl_TX, EM_SETSEL, len, len);
              SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
 

             return 0;    
		    }
			return 0;
		}
			return 0;


//****************************
//Now do the control commands  
//****************************     
 case WM_COMMAND:
//First do the listbox stuff (there has to be a better way!)

	/*	if (LOWORD (wParam) == ID_LIST && HIWORD (wParam) == LBN_SELCHANGE)
                        { 
				         if(Sending_pic == TRUE)return 0;                            //prevent transfer of call into send box while sending a pic
                         int     iIndex, call_length;
                         TCHAR   call[256];

                         iIndex  = SendMessage (hwndList, LB_GETCURSEL, 0, 0) ;      //highlight the call     
                         SendMessage (hwndList, LB_GETTEXT, iIndex, (LPARAM) call) ; //get the call from the listbox            
                         SetWindowText (hCtl_TX, call) ;                             //transfer it to the send box 
                         SetFocus(hCtl_TX); 
                         call_length = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, call_length, call_length);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );    
                        }
*/			//Note: don't do a "break" or "return 0" here as it will prevent the stuff below from executing

//And now the rest of the controls              
           switch( LOWORD (wParam) )
           {

				case ID_LIST:
					if (HIWORD (wParam) == LBN_SELCHANGE)   //This is the better way to do it!
                        { 
				         if(Sending_pic == TRUE)return 0;                            //prevent transfer of call into send box while sending a pic
                         int     len, iIndex;
                         TCHAR   call[256];

                         iIndex  = SendMessage (hwndList, LB_GETCURSEL, 0, 0) ;      //highlight the call   
                         len = SendMessage (hwndList, LB_GETTEXTLEN, iIndex, 0) ;      //highlight the call   
						 if(len < 1)break;
  
                         SendMessage (hwndList, LB_GETTEXT, iIndex, (LPARAM) call) ; //get the call from the listbox           

                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);  //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) call); //add it to the send box

                    //     SetWindowText (hCtl_TX, call) ;                             //transfer it to the send box 
                         SetFocus(hCtl_TX); 
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );

                         }
                        else
						{
						break;
					    }
						return 0;

/*
				case ID_COMMANDS:
					if (HIWORD (wParam) == LBN_SELCHANGE)   
                        { 
				         if(Sending_pic == TRUE)return 0;                            //prevent transfer of call into send box while sending a pic
                         int    len, iIndex;
                         TCHAR   command[256];
						 char trigger[256];
						 for ( len=0;len<256;len++ ){trigger[len]='\0'; }              //flush buffer with nulls
						
                         iIndex  = SendMessage (hwndCommands, LB_GETCURSEL, 0, 0) ;         //highlight the command     
                         SendMessage (hwndCommands, LB_GETTEXT, iIndex, (LPARAM) command) ; //get the command from the listbox            

                         strncpy(trigger, command, 1);                            //copy only the first character (the trigger)

                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) trigger); //add it to the send box

                         SetFocus(hCtl_TX); 
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );    
                        }
                        else
						{
						break;
					    }
						return 0;
*/
//*****************Commands messages*********************************************************************************************

				case IDM_QUERY:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "?"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}    
						return 0;
				case IDM_HEARD:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "$"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   	
						return 0;
				case IDM_LOCATION:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "@"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   	
						return 0;
				case IDM_STATION_MSG:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "&"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;		
				case IDM_VERSION:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "^"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;	
				case IDM_SQUELCH:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "_"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;			
				case IDM_SLOW_DOWN:	
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "<"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;
				case IDM_SPEED_UP:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) ">"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;	
				case IDM_PUT_FILE:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "#"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;	
				case IDM_ACTIVE:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "*"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;
				case IDM_GET_FILE:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "+"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;
				case IDM_SEND_ALERT:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "|"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   	
						return 0;
				case IDM_SEND_IMAGE:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "%"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;	
				case IDM_RELAY:	
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "!"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;	
				case IDM_RELAY_LATER:
						{
						 if(Sending_pic == TRUE)return 0; 
                         int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);         //get the length of the callsign in the send textbox
						 SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM) "~"); //add it to the send box
                         len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0); //put caret at end of call
                         SendMessage(hCtl_TX, EM_SETSEL, len, len);
                         SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 );
						}   
						return 0;	
//***************************End of commands messages**************************************************************

				case IDC_TX_BUTTON:
                    if((TXbutton == TRUE) | (signoise < squelch_level)) //back-to-front because Windoze has the screen upside down!)    
                        break;                                             //don't send if someone else is still sending  
                       
                    else
                      {
                                
   /* Set the ON button image*/ 
                       SendMessage(g_hwndTXbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapTX_ON);
                       SendMessage(g_hwndRXbutton, STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapRX_OFF);
                       SendMessage(g_hwndPausebutton, STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapPause_OFF); 
                       TXbutton = TRUE;
                       RXbutton = FALSE;
					   Pausebutton = FALSE;
					                      
	
  // Use this to add a CRLF when going from TX to RX and back again, and append a callsign at the start
           int crlf;
	       crlf=10;

           int space;
		   space = 32;

		   int eot;
		   eot = 8;   //= BS, unused in practice

		   char BOT[5]; //leave room for the null char
		   sprintf(BOT,"%c%c",space,crlf);

		   char EOT[6];
		   sprintf(EOT,"%c%c%c%c%c",space,space,eot,space,space);
		
	

		   char fsqEOT[6];
		   sprintf(fsqEOT,"%c%c",crlf,space);

         if(FSQCAL==TRUE)
		   {
             /*********************************
                 Do a CRC8 on the callsign
             **********************************/
          //   unsigned char crc;
		    			crc='\0';
             unsigned char ch;
             int i;
             for ( i=0;i<strlen(callsign);i++ )
              {
               ch = callsign[i];
               crc = crc8_table[(crc) ^ ch];
               crc &= 0xFF;
              }

		      sprintf(CRC,"%02x",crc);   //convert the character into two equivalent hex values

              SendMessage(hCtl_TX, EM_SETSEL,0,0);                          //Put CRC8(if FSQCAL enabled) first
              SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)CRC);  
           }       


           SendMessage(hCtl_TX, EM_SETSEL,0,0);                            
           SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)":");             // In normal operation, use only the colon
                
           SendMessage(hCtl_TX, EM_SETSEL,0,0);                            
           SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)callsign); 	       
  

           int len;                                                         //A CRLF appears to get added after the CRC when 
           len = GetWindowTextLength(hCtl_TX)+1;                            //responding in FSQCAL so need to remove it ????????WHY?????
  
           char buf[len];
           GetWindowText(hCtl_TX, buf, len);                                //Get all text in the TX screen
       //    remove_char_from_string(0xA, buf);  //CR                         //Remove any CRLF's (they triggered squelch closure in the old scheme
       //    remove_char_from_string(0xD, buf);  //LF                         //where ascii 10 was used to close squelch
           SetWindowText(hCtl_TX,"");                                       //Clear the TX screen ready for modified text to be put back


           SendMessage(hCtl_TX, EM_SETSEL,0,0);                            
           SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)buf); 	        //Put back the text  


//The BOT (beginning of transmission) ensures there is enough time for slow transmitters to catch the CRLF

           SendMessage(hCtl_TX, EM_SETSEL,0,0);                            
           SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)BOT);  

//The EOT character sequence is the Costas Symbol to close the sqielch 

           int text_length = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);  //Now put EOT sequence at the end
           SendMessage(hCtl_TX, EM_SETSEL, text_length, text_length);
           if(FSQCAL==TRUE)
				{
				 SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)EOT);
                } 
		   else
				{
                 SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)fsqEOT);
				}
//skip_EOT:

//Put mouse at end of text ready for next trnasmission
           SendMessage ( hCtl_TX, EM_SCROLLCARET, 0, 0 ); 
	       SendMessage ( hwnd, WM_MOUSEMOVE, 0, 0); 



           SetFocus (hCtl_TX);
  
                       Pa_StartStream(g_PAStream_Send);       //Start the sender
                       Pa_StopStream (g_PAStream);            //Stop the receiver


                 if(Use_cat == TRUE)
                        {
                         if(hex_commands  == TRUE)SerialPuts(hComm, hex_TX_command,  sizeof(hex_TX_command));   //this will send 80 bytes (the length of the array)
                         if(text_commands == TRUE)SerialPuts(hComm, text_TX_command, strlen(text_TX_command));  //this will send the actual number of characters
                        }

			     if(Use_cat == FALSE) 	
                        {
                         EscapeCommFunction(hComm,SETDTR);
                         EscapeCommFunction(hComm,SETRTS);
						}

						KillTimer(hwnd, 3); //stop the graphics update timer  
                      }
                    return 0;                   
                   
 

                   
             case IDC_PAUSE_BUTTON:
                    if(Pausebutton == TRUE) //if already depressed then quit - we want to simulate radiobutton behaviour
                        break;  
                      
                    else
                      {
   /* Set the PAUSE button image*/ 

                       SendMessage(g_hwndTXbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapTX_OFF);
                       SendMessage(g_hwndRXbutton, STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapRX_OFF); 
                       SendMessage(g_hwndPausebutton, STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapPause_ON); 
                       SendMessage(g_hwndSAVEbutton, STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSAVE_OFF);

                       TXbutton    = FALSE;
                       RXbutton    = FALSE;
					   Pausebutton = TRUE;
                       MANUAL_SAVE_FILE   = FALSE;

                       SetFocus (hCtl_TX);   //Put focus back to send box

                       Pa_StopStream(g_PAStream);            //Stop the receiver
                       Pa_StopStream(g_PAStream_Send);       //Stop the sender


                 if(Use_cat == TRUE)
                        {
                         if(hex_commands  == TRUE)SerialPuts(hComm, hex_RX_command,  sizeof(hex_RX_command));
                         if(text_commands == TRUE)SerialPuts(hComm, text_RX_command, strlen(text_RX_command));
                        }

			     if(Use_cat == FALSE) 	
                        {
                         EscapeCommFunction(hComm,CLRDTR);
                         EscapeCommFunction(hComm,CLRRTS);
						}
                 KillTimer(hwnd, 3); //stop the graphics update timer     
          
                      }
                    return 0;               


                  
             case IDC_RX_BUTTON:
                    if(RXbutton == TRUE) //if already depressed then quit - we want to simulate radiobutton behaviour
                        break;  
                      
                    else
                      {
   /* Set the ON button image*/ 

                       SendMessage(g_hwndTXbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapTX_OFF);
                       SendMessage(g_hwndRXbutton, STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapRX_ON); 
                       SendMessage(g_hwndPausebutton, STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapPause_OFF);
                       SendMessage(g_hwndSAVEbutton, STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSAVE_OFF);

                       TXbutton    = FALSE;
                       RXbutton    = TRUE;
					   Pausebutton = FALSE;
                       MANUAL_SAVE_FILE   = FALSE;
					   
  
                       SetFocus (hCtl_TX);

                    //   SendMessage ( hCtl, WM_CHAR, 0xD, 0);  //Start a new line on the receive screen
                                                              //to separate received from sent text
                    // Can't use WM_CHAR reliably with Richedit controls
                      
                       Pa_StopStream (g_PAStream_Send);       //Stop the sender
					   Sleep(50);                             //pause a liuttle to allow sender to stop and not residual junk exceeding the squelch and printing rubbish
                       Pa_StartStream(g_PAStream);           //Start the receiver



                 if(Use_cat == TRUE)
                        {
                         if(hex_commands  == TRUE)SerialPuts(hComm, hex_RX_command,  sizeof(hex_RX_command));
                         if(text_commands == TRUE)SerialPuts(hComm, text_RX_command, strlen(text_RX_command));
                        }

			     if(Use_cat == FALSE) 	
                        {
                         EscapeCommFunction(hComm,CLRDTR);
                         EscapeCommFunction(hComm,CLRRTS);
						}
                 
				SetTimer (hwnd, 3, waterfall_timer, NULL);  //restart the graphics update timer
                      }
                    return 0; 
              
             case IDC_QTC_BUTTON:
                   {
                   SendMessage(g_hwndCQbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapQTC_ON);
                   SetTimer (hwnd, 4, 100, NULL);    //Start a 100msec timer to "flash" the button blue momentarily to mimic a button press

                   int len;
                   len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" "); //add a space incase it is after the callsign
				   len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)cq_text); //Send it all to the TX text box

				   SetFocus(hCtl_TX);                //Make sure we set focus back to the TX box otherwise the ENTER key won't work
				   }
				   return 0;

            case IDC_QTH_BUTTON:
                   {
                   SendMessage(g_hwndQTHbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapQTH_ON);
				   SetTimer (hwnd, 4, 100, NULL);     //Start a 100msec timer to "flash" the button blue momentarily to mimic a button press
                   int len;
                   len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" "); //add a space incase it is after the callsign
                   len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)location); //Send it all to the TX text box

				   SetFocus(hCtl_TX);                 //Make sure we set focus back to the TX box otherwise the ENTER key won't work
				   }
				   return 0;



             case IDC_FSQCAL_BUTTON:
                    if(FSQCAL == TRUE)
					 {
					   FSQCAL = FALSE;
					   SendMessage(g_hwndFSQCALbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSELCAL_OFF);
					   SendMessage(g_hwndSAVEbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSAVE_OFF); //turn off CQ button in case it is one when selcal quits
					   SendMessage(g_hwndSOUNDINGbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSOUNDING_OFF);//and the sound button
                       KillTimer(hwnd,2);
                       SendMessage(g_hwndMSGRXbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapMSGRX_OFF); //and MSR_RX button
                       FSQCAL                = FALSE;
                       SOUNDING              = FALSE;
                       print                 = FALSE;
                       MANUAL_SAVE_FILE             = FALSE;
                       MSGRX                 = FALSE;
                       OPEN_FILE             = FALSE;
                       SAVE_MESSAGE          = FALSE;
                       CALL_FOUND            = FALSE;
                       fsqcal_active         = TRUE; //Set "sleep" mode back to "active" ie normal, so it will work next time
        
                       CheckMenuItem(menu,IDM_FSQCAL_ACTIVE,MF_CHECKED);
				       CheckMenuItem(menu,IDM_FSQCAL_SLEEP,MF_UNCHECKED);
                       fclose(heardlog); 
                       break;                                             
                     }  
                    else
                     {
                       SendMessage(g_hwndFSQCALbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSELCAL_ON);
					   FSQCAL = TRUE;
					   fsqcal_active = TRUE; 
                       break;		
                     }
				   return 0;

             case IDC_SAVE_BUTTON:
                    if(FSQCAL == FALSE)break;
                    if(MANUAL_SAVE_FILE == TRUE)
					 {
					   MANUAL_SAVE_FILE = FALSE;
					   SendMessage(g_hwndSAVEbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSAVE_OFF);
                       break;                                             
                     }  
                    else
                     {
                       MANUAL_SAVE_FILE = TRUE;
					   SendMessage(g_hwndSAVEbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSAVE_ON);

                       break;		
                     }                   
				   return 0;

             case IDC_SOUNDING_BUTTON:
					if(FSQCAL == FALSE)break;
                    if(SOUNDING == TRUE) //This just sends own call:    it is not needed other than to have it sent via a regular timer
					 {
					   SOUNDING = FALSE;
					   SendMessage(g_hwndSOUNDINGbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSOUNDING_OFF);
                       KillTimer(hwnd,2);
                       break;                                             
                     }  
                    else
                     {
					   SOUNDING = TRUE;
                       if(sounding_message_on == TRUE)
						 {
						  int len;
                          len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                          SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)" "); //add a space incase it is after the callsign
                          len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                          SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)sounding_message); //Send it all to the TX text box
                         }
              
                 /*      SYSTEMTIME time_stamp;
                       char time[256]; 
                       GetLocalTime(&time_stamp);            
                       sprintf(time, "allcall sounding %02d.%02d", time_stamp.wHour, time_stamp.wMinute );
                       SetWindowText(hCtl_TX, time);  //Send it all to the TX text box
				 */      SetFocus(hCtl_TX);
                       SendMessage(g_hwndSOUNDINGbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapSOUNDING_ON);
					   PostMessage(g_hwndTXbutton, WM_LBUTTONDOWN, 0, 0) ;  //start sending	straight away
					   SetTimer(hwnd, 2, sound_interval, NULL);		//user selectable 1, 10, or 30 minutes
                       break;		
                     }                   					
				   return 0;

             case IDC_MSGRX_BUTTON:
					if(FSQCAL == FALSE)break;
					if(OPEN_FILE == TRUE)break;   //don't interrupt the file printing process
                    if(MSGRX == FALSE) 
					 {
					   MSGRX = TRUE;
					   SendMessage(g_hwndMSGRXbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapMSGRX_OFF);                 
                       ShellExecute(hwnd, "open", path_plus_filename, NULL, NULL, SW_SHOWNORMAL);       //read the file from the shared folder
                       break;                                             
                     }  
                    else
                     {
					   MSGRX = FALSE;
                       SendMessage(g_hwndMSGRXbutton,STM_SETIMAGE, IMAGE_BITMAP,(LPARAM) hBitmapMSGRX_ON);
					 
                       break;		
                     }                   					
				   return 0;

             case IDM_SOUND_MESSAGE_ONOFF:
                  if(sounding_message_on == TRUE)
					{
					  sounding_message_on = FALSE;
                      CheckMenuItem(menu,IDM_SOUND_MESSAGE_ONOFF,MF_UNCHECKED);
					}
				   else
                    {
					  sounding_message_on = TRUE;
                      CheckMenuItem(menu,IDM_SOUND_MESSAGE_ONOFF,MF_CHECKED);
					}
				  return 0;

 
             case IDM_TIMESTAMP_ONOFF:
                  if(AddTimestampandSNR == TRUE)
					{
					  AddTimestampandSNR = FALSE;
                      CheckMenuItem(menu,IDM_TIMESTAMP_ONOFF,MF_UNCHECKED);
					}
				   else
                    {
					  AddTimestampandSNR = TRUE;
                      CheckMenuItem(menu,IDM_TIMESTAMP_ONOFF,MF_CHECKED);
					}
				  return 0;



             case IDM_EDIT_COPY:            
				 SendMessage(hCtl, WM_COPY, 0,0);
                  return 0;   
  
             case IDM_EDIT_PASTE:
					 SendMessage(hCtl, WM_PASTE, 0,0);
                  return 0;

             case IDM_EDIT_SELECTALL:
                 {
				  SendMessage(g_hwndPausebutton, WM_LBUTTONDOWN, 0, 0) ;  //pause the screen to avoid losing text colours 
                  int len = SendMessage(hCtl, WM_GETTEXTLENGTH, 0, 0);
                  SendMessage(hCtl, EM_SETSEL, 0, len);
	             }
                  return 0;

             case IDM_MONITOR_COPY:       
					 SendMessage(hwndMonitor, WM_COPY, 0,0);
                  return 0;   
  
             case IDM_MONITOR_PASTE:
					 SendMessage(hwndMonitor, WM_PASTE, 0,0);
                  return 0;

             case IDM_MONITOR_SELECTALL:
                 {
				  SendMessage(g_hwndPausebutton, WM_LBUTTONDOWN, 0, 0) ;  //pause the screen to avoid losing text colours 
                  int len = SendMessage(hwndMonitor, WM_GETTEXTLENGTH, 0, 0);
                  SendMessage(hwndMonitor, EM_SETSEL, 0, len); 

          //        PostMessage(g_hwndRXbutton, WM_LBUTTONDOWN, 0, 0) ;             
	             }
                  return 0;



             case IDM_MARKER_ON:  
                  {symbol_marker = TRUE;
                   CheckMenuItem(menu,IDM_MARKER_ON,MF_CHECKED);
				   CheckMenuItem(menu,IDM_MARKER_OFF,MF_UNCHECKED);}
                  return 0;

             case IDM_MARKER_OFF:  
                  {symbol_marker = FALSE;
                   CheckMenuItem(menu,IDM_MARKER_OFF,MF_CHECKED);
				   CheckMenuItem(menu,IDM_MARKER_ON,MF_UNCHECKED);}
                  return 0;        

             case IDM_3_PEAKS:  
                  {peak_hits = 3;
                   CheckMenuItem(menu,IDM_3_PEAKS,MF_CHECKED);
				   CheckMenuItem(menu,IDM_6_PEAKS,MF_UNCHECKED);}
                  return 0;

             case IDM_6_PEAKS:  
                  {peak_hits = 6;
                   CheckMenuItem(menu,IDM_6_PEAKS,MF_CHECKED);
				   CheckMenuItem(menu,IDM_3_PEAKS,MF_UNCHECKED);}
                  return 0;  

             case IDM_6_BAUD:  
                  {symbol_length = 1;
                   CheckMenuItem(menu,IDM_6_BAUD,MF_CHECKED);
				   CheckMenuItem(menu,IDM_45_BAUD,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_3_BAUD,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_2_BAUD,MF_UNCHECKED);}		
                  return 0;     
   
             case IDM_45_BAUD:  
                  {symbol_length = 1.5;
                   CheckMenuItem(menu,IDM_6_BAUD,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_45_BAUD,MF_CHECKED);
                   CheckMenuItem(menu,IDM_3_BAUD,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_2_BAUD,MF_UNCHECKED);}	
                  return 0;     

             case IDM_3_BAUD:  
                  {symbol_length = 2;
                   CheckMenuItem(menu,IDM_6_BAUD,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_45_BAUD,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_3_BAUD,MF_CHECKED);
				   CheckMenuItem(menu,IDM_2_BAUD,MF_UNCHECKED);}	
                  return 0; 
 
             case IDM_2_BAUD:  
                  {symbol_length = 3;
                   CheckMenuItem(menu,IDM_6_BAUD,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_45_BAUD,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_3_BAUD,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_2_BAUD,MF_CHECKED);}	
                  return 0;     


             case IDM_4_BINS:  
                  {tone_spacing = 4;
                   CheckMenuItem(menu,IDM_4_BINS,MF_CHECKED);
				   CheckMenuItem(menu,IDM_3_BINS,MF_UNCHECKED);}
                  return 0;     
   
             case IDM_3_BINS:  
                  {tone_spacing = 3;
                   CheckMenuItem(menu,IDM_4_BINS,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_3_BINS,MF_CHECKED);}

             case IDM_SOUND_1:  
                  {sound_interval = 60000;
                   CheckMenuItem(menu,IDM_SOUND_1,MF_CHECKED);
				   CheckMenuItem(menu,IDM_SOUND_10,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_SOUND_30,MF_UNCHECKED);}
                  return 0;     

             case IDM_SOUND_10:  
                  {sound_interval = 600000;
                   CheckMenuItem(menu,IDM_SOUND_1,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_SOUND_10,MF_CHECKED);
                   CheckMenuItem(menu,IDM_SOUND_30,MF_UNCHECKED);}
                  return 0;     

             case IDM_SOUND_30:  
                  {sound_interval = 1800000;
                   CheckMenuItem(menu,IDM_SOUND_1,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_SOUND_10,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_SOUND_30,MF_CHECKED);}
                  return 0;     

             case IDM_TIMEOUT_10:  
                  {Reply_retries = 10;
                   CheckMenuItem(menu,IDM_TIMEOUT_10,MF_CHECKED);
				   CheckMenuItem(menu,IDM_TIMEOUT_20,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_TIMEOUT_100,MF_UNCHECKED);}
                  return 0;     

             case IDM_TIMEOUT_20:  
                  {Reply_retries = 20;
                   CheckMenuItem(menu,IDM_TIMEOUT_10,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_TIMEOUT_20,MF_CHECKED);
                   CheckMenuItem(menu,IDM_TIMEOUT_100,MF_UNCHECKED);}
                  return 0;     

             case IDM_TIMEOUT_100:  
                  {Reply_retries = 100;
                   CheckMenuItem(menu,IDM_TIMEOUT_10,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_TIMEOUT_20,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_TIMEOUT_100,MF_CHECKED);}
                  return 0;     
 
             case IDM_BLUE:  
                  {Blue = TRUE;
                   CheckMenuItem(menu,IDM_BLUE,MF_CHECKED);
				   CheckMenuItem(menu,IDM_GREEN,MF_UNCHECKED);}
                  return 0;

             case IDM_GREEN:  
                  {Blue = FALSE;
                   CheckMenuItem(menu,IDM_GREEN,MF_CHECKED);
				   CheckMenuItem(menu,IDM_BLUE,MF_UNCHECKED);}
                  return 0;        

             case IDM_COLOUR_ON:  
                  {Text_colour = TRUE;
                   CheckMenuItem(menu,IDM_COLOUR_ON,MF_CHECKED);
				   CheckMenuItem(menu,IDM_COLOUR_OFF,MF_UNCHECKED);}
                  return 0;

             case IDM_COLOUR_OFF:  
                  {Text_colour = FALSE;
                   CheckMenuItem(menu,IDM_COLOUR_OFF,MF_CHECKED);
				   CheckMenuItem(menu,IDM_COLOUR_ON,MF_UNCHECKED);}
                  return 0;        

             case IDM_AGC_OFF:  
                  {agcOFF = TRUE;
                   CheckMenuItem(menu,IDM_AGC_OFF,MF_CHECKED);
                   CheckMenuItem(menu,IDM_AGC_FAST,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_AGC_SLOW,MF_UNCHECKED);}
                  return 0;

             case IDM_AGC_FAST:  
                  {agcfast = TRUE;
                   agcOFF  = FALSE;
                   CheckMenuItem(menu,IDM_AGC_OFF,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_AGC_FAST,MF_CHECKED);
				   CheckMenuItem(menu,IDM_AGC_SLOW,MF_UNCHECKED);}
                  return 0;

             case IDM_AGC_SLOW:  
                  {agcfast = FALSE;
                   agcOFF  = FALSE;
                   CheckMenuItem(menu,IDM_AGC_OFF,MF_UNCHECKED);
                   CheckMenuItem(menu,IDM_AGC_SLOW,MF_CHECKED);
				   CheckMenuItem(menu,IDM_AGC_FAST,MF_UNCHECKED);}
                  return 0;                                                          


			 case IDM_WATERFALL_FAST:
                  {waterfall_timer = 20;
				   KillTimer(hwnd,3);
				   SetTimer (hwnd, 3, 20, NULL);
                   CheckMenuItem(menu,IDM_WATERFALL_FAST,MF_CHECKED);
				   CheckMenuItem(menu,IDM_WATERFALL_SLOW,MF_UNCHECKED);}
                  return 0;       

			 case IDM_WATERFALL_SLOW:
                  {waterfall_timer = 50;
				   KillTimer(hwnd,3);
				   SetTimer (hwnd, 3, 50, NULL);
                   CheckMenuItem(menu,IDM_WATERFALL_FAST,MF_UNCHECKED);
				   CheckMenuItem(menu,IDM_WATERFALL_SLOW,MF_CHECKED);}
                  return 0;       

             case IDM_TIMESTAMP_ON:  
                  {Timestamp = TRUE;
                   CheckMenuItem(menu,IDM_TIMESTAMP_ON,MF_CHECKED);
				   CheckMenuItem(menu,IDM_TIMESTAMP_OFF, MF_UNCHECKED);}
                  return 0;                          

             case IDM_TIMESTAMP_OFF:  
                  {Timestamp = FALSE;
                   CheckMenuItem(menu,IDM_TIMESTAMP_OFF,MF_CHECKED);
				   CheckMenuItem(menu,IDM_TIMESTAMP_ON, MF_UNCHECKED);}
	
             case IDM_1150_HZ:  
                  {channel_offset = 0;
                   CheckMenuItem(menu,IDM_1150_HZ,MF_CHECKED);
				   CheckMenuItem(menu,IDM_1500_HZ, MF_UNCHECKED);}
                  return 0;                          

             case IDM_1500_HZ:  
                  {channel_offset = 350;
                   CheckMenuItem(menu,IDM_1500_HZ,MF_CHECKED);
				   CheckMenuItem(menu,IDM_1150_HZ, MF_UNCHECKED);}  
                  return 0;                                                                             

             case IDM_FORMAT_FONT:
                  if (PopFontChooseFont (hwnd))
                       PopFontSetFont (hCtl) ;
               
              	 return 0 ;


            case IDM_PTT_CONTROLS:
                   DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_PTT), NULL, (DLGPROC)PTTDlgProc);
                   Use_file_commands();
                   return 0;

            case IDM_SOUNDCARD_CONTROLS:
                    return DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_SOUNDCARD), NULL, (DLGPROC)SOUNDCARDDlgProc);

            case IDM_CALLSIGN:
                    DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_CALLSIGN), NULL, (DLGPROC)CallsignDlgProc);
                    sprintf(banner,"%s  %s",software_version,callsign);
                    SetWindowText(hwnd,banner);

				//Delete any "*.nocall" files
/*
					remove(NocallShortpath);	
					remove(NocallLongpath);		
					remove(NocallImagespath);		//only works here, and not for the other two - WHY????		
*/		
					
				//Update the callsign in the files index
					strcpy(FilesShortindexpath,full_incoming_path);
					strcpy(FilesLongindexpath,full_incoming_path);  
					strcpy(Imageindexpath,full_incoming_path);
					strcat(FilesShortindexpath,"/Short.");
					strcat(FilesLongindexpath,"/Long.");
					strcat(Imageindexpath,"/Images.");
					strcat(FilesShortindexpath,callsign);
					strcat(FilesLongindexpath,callsign);
					strcat(Imageindexpath,callsign);

					ListShortDirectoryContents(full_incoming_path, FilesShortindexpath);
					ListLongDirectoryContents(full_incoming_path, FilesLongindexpath);
					ListShortDirectoryContents(full_image_path, Imageindexpath);


					return 0;

            case IDM_QTC:
                    return DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_QTC), NULL, (DLGPROC)QTCmessageDlgProc);

            case IDM_QTH:
                    return DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_QTH), NULL, (DLGPROC)QTHDlgProc);

            case IDM_SOUNDING_MESSAGE:
                    return DialogBox(hThisInstance, MAKEINTRESOURCE(DLG_SOUNDING_MESSAGE), NULL, (DLGPROC)SoundingMessageDlgProc);					

//===============================================================================================================
//     IMAGE MODE STUFF
//===============================================================================================================
            case IDC_SEND_PIC_BUTTON: 
				{
                 send_pic();
			    }				
				 return 0;

            case IDC_REMOTE_SEND_PIC_BUTTON: 
				{
                 remote_send_pic();
			    }				
				 return 0;


            case IDC_WEBCAM_BUTTON: 
				{
              //   send_webcam();
                Directshow_webcam();
			    }				
				 return 0;


            case IDC_RECEIVE_PIC_BUTTON:
				{
				 receive_pic();
			    }			
				 return 0;				
				
//===============================================================================================================
//     END OF IMAGE MODE STUFF
//===============================================================================================================



            case IDM_FAST_SPECTRUM:
                    SpectrumAveragebutton = TRUE;
                    CheckMenuItem(menu,IDM_FAST_SPECTRUM,MF_CHECKED);
				    CheckMenuItem(menu,IDM_SLOW_SPECTRUM,MF_UNCHECKED);
                    return 0;

            case IDM_SLOW_SPECTRUM:
                    SpectrumAveragebutton = FALSE;
                    CheckMenuItem(menu,IDM_SLOW_SPECTRUM,MF_CHECKED);
				    CheckMenuItem(menu,IDM_FAST_SPECTRUM,MF_UNCHECKED);
                    return 0;

              case IDM_SEND_FILE:
                  {
             
                   if(ChooseFile(hwnd, FileName)!=1)break;  //this avoids a crash if the ChooseFile dialog is open and then ESC is pressed!

                   File_to_send = fopen(FileName, "r");

                   fseek(File_to_send, 0, SEEK_END);
                   long fsize = ftell(File_to_send);
				   if(fsize>20000)fsize = 20000;   //limit the size of the text to be sent!
                   fseek(File_to_send, 0, SEEK_SET);
                   unsigned char file_text[fsize];
				   int i;
				   for (i=0;i<fsize;i++)file_text[i]='\0';    //Must flush the buffer
                   fread(file_text, fsize, 1, File_to_send);

				   char filename_plus_brackets[64];
                  
                   unsigned char *ssc; //pointer to the last "\"

                   ssc = strrchr(FileName, 92)+1; //add 1 as it points to the "\" and we want the filename only

                   sprintf(filename_plus_brackets,"%s%s%s","[",ssc,"]");

                   int length = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   SendMessage(hCtl_TX, EM_REPLACESEL, length, (LPARAM)filename_plus_brackets);  //Append file to the preamble
                   length = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
                   SendMessage(hCtl_TX, EM_REPLACESEL, length, (LPARAM)file_text);  //Append file to the preamble

               
				   fclose(File_to_send);
              
                  }
                  return 0;
    
             case IDM_FILECLEAR:   //rename old log to archived one plus time stamp
                 {
                  char old_log[256];
                  SYSTEMTIME time_stamp;
              //    char time_stamp[256]; 
                  GetLocalTime(&time_stamp);
                  sprintf(old_log, "Heardlog_%02d_%02d_%02d_%02d_%02d.txt",time_stamp.wYear, time_stamp.wMonth, time_stamp.wDay,time_stamp.wHour,time_stamp.wMinute,time_stamp.wSecond  );
	  
                  int result;
				  result = rename("Heardlog.txt",old_log);
                  if(result==0)MessageBox(hwnd,"Heardlog successfully renamed","heardlog status",MB_OK | MB_ICONINFORMATION);
                 }
 
                  return 0; 

//Put all the ShellExecute routines here for tidiness
 
             case IDM_FILEOPEN:
       
                  ShellExecute(hwnd, "open", fullHeardLogpath, NULL, NULL, SW_SHOWNORMAL);
 
                  return 0;

             case IDM_LAUNCH_FSQPLOT:
       
                  ShellExecute(hwnd, "open", full_path_FSQplot, NULL, NULL, SW_SHOWNORMAL);
 
                  return 0;

			 case IDM_REFRESH_DIRECTORIES:
                    if(strstr(callsign,"nocall")!=0)
					{
					//	MessageBox(hwnd,"","",MB_OK);
						break;
					}
					else
					{
					ListShortDirectoryContents(full_incoming_path, FilesShortindexpath);
					ListLongDirectoryContents(full_incoming_path, FilesLongindexpath);
					ListShortDirectoryContents(full_image_path, Imageindexpath);
 					}
                  return 0;


             case IDM_AUDIODEVICES:
                  ShellExecute(hwnd, "open", "rundll32.exe",
                                    "shell32.dll,Control_RunDLL mmsys.cpl,,1",NULL, SW_SHOWNORMAL);// 1 opens "Recording" tab in W7, 2 opens "Audio" in XP
                  SetFocus (hCtl_TX);   //Put focus back to send box (doesn't appear to work here?)
                
				  return 0;


             case IDM_FSQ_HELP:
                  ShellExecute(hwnd, "open", full_path_FSQhelp, NULL, NULL, SW_SHOWNORMAL);
                  SetFocus (hCtl_TX);   //Put focus back to send box (doesn't appear to work here either - probably because the ccntrols are outside the program) 
                  return 0;

            case IDM_TOUR_HELP: 
                  ShellExecute(hwnd, "open", full_path_TOURhelp, NULL, NULL, SW_SHOWNORMAL);
                  SetFocus (hCtl_TX);   //Put focus back to send box (doesn't appear to work here either - probably because the ccntrols are outside the program) 
                  return 0;

            case IDM_TELEMETRY_HELP: 
                  ShellExecute(hwnd, "open", full_path_TELEMETRYhelp, NULL, NULL, SW_SHOWNORMAL);
                  SetFocus (hCtl_TX);   //Put focus back to send box (doesn't appear to work here either - probably because the ccntrols are outside the program) 
                  return 0;
 
/*            case IDM_FSQCALL_HELP: 
                  ShellExecute(hwnd, "open", full_path_CALLhelp, NULL, NULL, SW_SHOWNORMAL);
                  SetFocus (hCtl_TX);   //Put focus back to send box (doesn't appear to work here either - probably because the ccntrols are outside the program) 
                  return 0;
*/
             case IDM_IMAGE_HELP: 
                  ShellExecute(hwnd, "open", full_path_IMAGEhelp, NULL, NULL, SW_SHOWNORMAL);
                  SetFocus (hCtl_TX);   //Put focus back to send box (doesn't appear to work here either - probably because the ccntrols are outside the program) 
                  return 0;

             case IDM_SYNTAX_HELP:
                  ShellExecute(hwnd, "open", full_path_SYNTAXhelp, NULL, NULL, SW_SHOWNORMAL);
                  SetFocus (hCtl_TX);   //Put focus back to send box (doesn't appear to work here either - probably because the ccntrols are outside the program) 
                  return 0;

             case IDM_RULES_HELP: 
                  ShellExecute(hwnd, "open", full_path_RULEShelp, NULL, NULL, SW_SHOWNORMAL);
                  SetFocus (hCtl_TX);   //Put focus back to send box (doesn't appear to work here either - probably because the ccntrols are outside the program) 
                  return 0;

             case IDM_HELPABOUT:
                  vShowAboutBox (hwnd);
                  SetFocus (hCtl_TX);   //Put focus back to send box (this works OK)
                  return 0;

           }
           break;
/*
		case WM_SIZE:
		{
   
        //Now resize the other windows and controls  931  573
			RECT rct;
			int max_size;
            GetClientRect (hwnd, &rct);

			if(rct.right>1130)rct.right=1130;

            MoveWindow (hCtl   ,   0, 0, rct.right-93, 289, TRUE);
            MoveWindow (hwndList   ,   rct.right-93,0,103,300, TRUE);
    //        MoveWindow (hwndCommands   ,   rct.right-93,290,103,174+33+30, TRUE);
      //      MoveWindow (hwndMonitor   ,   370,290,-463+rct.right,212-16, TRUE);
   
       InvalidateRect (hwnd, NULL,TRUE);
       UpdateWindow (hwnd);                      //repaint the whole screen        
	}
				return 0;
*/
    

           
    case WM_DESTROY:

  //MessageBox(hwnd,fullpath,"",MB_OK); //to check if path and filename are correct
	
        //Check to see if "comports" has a \\.\ prepended (eg \\.\COM13). If so, remove everything before the "C" of COM13
      //   sprintf(comports, "%s","\\\\.\\COM13");

         remove_char_from_string(0x5C, comports);  // "\"
         remove_char_from_string(0x2E, comports);  // "."
         remove_char_from_string(0x5C, comports);  // "\"

             RECT rc1;
			 GetWindowRect (hwnd, &rc1); //get main window coordinates
			 screenX = rc1.left;         
			 screenY = rc1.top;
			 screenW = rc1.right - rc1.left;
			 screenH = rc1.bottom - rc1.top;    

		//Save parameters to setup file
         setupfile = fopen(fullpath, "w");

         fprintf(setupfile, "%s\n", comports);
         fprintf(setupfile, "%d\n", baudrate);

         fprintf(setupfile, "%s", parity);            
         fprintf(setupfile, "%d\n", bitsperbyte);
         fprintf(setupfile, "%d\n", stopbits);

         fprintf(setupfile, "%d\n", rig_index);
         fprintf(setupfile, "%d\n", bright);

         remove_char_from_string(0xA, callsign);  //CR
         remove_char_from_string(0xD, callsign);  //LF

         fprintf(setupfile, "%s\n", callsign);
 
		 fprintf(setupfile, "%d\n", soundcard_in_ID);
         fprintf(setupfile, "%d\n", soundcard_out_ID);

         fprintf(setupfile, "%s\n", cq_text);
         fprintf(setupfile, "%s\n", location);

         fprintf(setupfile, "%s\n", CAT_tx_file_command);   //CAT commands default in text format (put in quotes)
         fprintf(setupfile, "%s\n", CAT_rx_file_command); 

         fprintf(setupfile, "%d\n",screenX);
         fprintf(setupfile, "%d\n",screenY);
         fprintf(setupfile, "%d\n",screenW);
         fprintf(setupfile, "%d\n",screenH);
        
		 fprintf(setupfile, "%s\n\n\n\n", "");

         fprintf(setupfile, "Description of parameters above - "
                            "\n-comport"
			                "\n-baudrate"
			                "\n-parity"
			                "\n-bits"
			                "\n-stopbits"
				            "\n-Rig list index"
			             	"\n-Waterfall brightness setting"
			                "\n-callsign"
			                "\n-soundcard in"
			                "\n-soundcard out"
			                "\n-CQ or other message text"
				            "\n-Station location (qth etc)"
							"\n-CAT command for TX if not in dropdown list"
			                "\n-CAT command for RX if not in dropdown list"
				            "\n\n (note: These can be text or hexadecimal values" 
				            "\n        -see your radio manual for the commands"
				            "\n         The default eaxmple above is for the ICOM7200,"
                            "\n         but many rigs use text such as TX; and RX;"
			                "\n         You may also have to edit the baudrate and stopbits)"
				            "\n\n-Main window coordinates, x, y, width, and height");
         fclose(setupfile);
 
 	
  
      KillTimer (hwnd, 0);          // what if SetTimer() was never called? *#*
      KillTimer (hwnd, 5);

      Pa_StopStream (g_PAStream);   // result ignored...
      Pa_CloseStream (g_PAStream);	 
      Pa_Terminate ();
  
      CloseHandle(hComm);
      PostQuitMessage(0);

      break;



    case WM_PAINT:

    //  return OnWmPaint (hwnd);
          OnWmPaint (hwnd);

     return 0;

              
                                                        
         
    case WM_LBUTTONDOWN :
      {
         POINT pt;
         HWND  hwndChild;

         pt.x = LOWORD( lParam );
         pt.y = HIWORD( lParam );

    //     hwndChild = ChildWindowFromPoint( hwnd, pt );
    //     if((hwndChild ==hwnd) & (pt.x > 5) & (pt.x < 30)& (pt.y > 366) & (pt.y < 460) )// WindowFromDC(hdcMem))       // Mouse is in S/N meter image area
          if(  (pt.x > 5) & (pt.x < 30)& (pt.y > bottom_offset+366) & (pt.y < bottom_offset+460) )
           {
             GetCursorPos (&pt);
             ScreenToClient  (hwnd, &pt);
             squelch_level =  pt.y-bottom_offset;    //Set new squelch limit.
			}
      
      }
      break;

                                                                                               


    case WM_MOUSEMOVE:

          SetCursor(hCursorArrow);
          SetWindowLong (hwnd, DWL_MSGRESULT, 1);   //ensure mouse is default arrow if outside the spectrum display   
      return 0L;

    default:          /* for messages that we don't deal with */
      return DefWindowProc (hwnd, message, wParam, lParam);
  }

  return DefWindowProc (hwnd, message, wParam, lParam);
}


/*------------------------------------------------------------------------------
 *
 *      Window$ main()
 */


int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nShowHow )
{
                    
 
    InitCommonControls(); // loads common controls DLL 


g_hInst = hThisInstance; 
  //HWND hwnd;                // this is the handle for our window
  MSG messages;             // here messages to the application are saved
  WNDCLASSEX wc;            // data structure for the windowclass

  sprintf(software_version,"%s"," FSQCALL v0.41");

 
  // Set up the main window
 
  wc.cbSize        = sizeof (WNDCLASSEX);
  wc.style         = CS_HREDRAW | CS_VREDRAW; // or 0?
  wc.lpfnWndProc   = WindowProcedure;
  wc.cbClsExtra    = 0 ;
  wc.cbWndExtra    = 0 ;
  wc.hInstance     = hThisInstance;
  wc.hIcon         = LoadIcon(hThisInstance,TEXT("PROGRAM_ICON"));
  wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH) (COLOR_BTNFACE);  // black
  wc.lpszMenuName  = NULL;         
  wc.lpszClassName = g_szClassName;
  wc.hIconSm       = LoadIcon(hThisInstance,TEXT("PROGRAM_ICON"));

  if (!RegisterClassEx (&wc))
  {
    MessageBox (NULL, "Window Registration Failed!", "Error!",
                MB_ICONEXCLAMATION | MB_OK);
    return 0;
  } 

  // The class is registered, let's create the program

  hwnd = CreateWindowEx (
           0,                             // use WS_EX_CLIENTEDGE for "sunken edge" (else 0)
           g_szClassName,                 // window class name
           software_version,              // title Text
           WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_SIZEBOX,                
           CW_USEDEFAULT,                 // Windows decides the initial X position
           CW_USEDEFAULT,                 // Windows decides the initial Y position
           CW_USEDEFAULT,                 // The window's width INCLUDING BORDER FRAME!
           CW_USEDEFAULT,                 // The window's height INCLUDING BORDER FRAME!
           HWND_DESKTOP,                  // The window is a child-window to desktop
           NULL,                          // No menu
           hThisInstance,                 // Program instance handle
           NULL                           // No Window creation data
           );


      
//*********************************************************************************************************
if (hwnd == NULL)
  {
    MessageBox (NULL, "Window Creation Failed!", "Error!",
                MB_ICONEXCLAMATION | MB_OK);
    return 0;
  }

  // Make the window visible on the screen

  ShowWindow (hwnd, SW_SHOW);//nShowHow );
//  UpdateWindow (hwnd);// not needed since we use a timer tick for redraw
{
    menu = LoadMenu(hThisInstance, MAKEINTRESOURCE(ID_MENU));
    SetMenu(hwnd, menu);  
}
  
  // Run the message loop. It will run until GetMessage() returns 0

  while (GetMessage (&messages, NULL, 0, 0) > 0)
  {
    // Translate virtual-key messages into character messages
    TranslateMessage (&messages);
    // Send message to WindowProcedure
    DispatchMessage (&messages);
  }

  // The program return-value is 0 - The value that PostQuitMessage() gave

  return messages.wParam;
}

